package zio.aws.emr.model
import zio.aws.emr.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ShrinkPolicy(
    decommissionTimeout: Optional[Integer] = Optional.Absent,
    instanceResizePolicy: Optional[zio.aws.emr.model.InstanceResizePolicy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ShrinkPolicy = {
    import ShrinkPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ShrinkPolicy
      .builder()
      .optionallyWith(
        decommissionTimeout.map(value => value: java.lang.Integer)
      )(_.decommissionTimeout)
      .optionallyWith(instanceResizePolicy.map(value => value.buildAwsValue()))(
        _.instanceResizePolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ShrinkPolicy.ReadOnly =
    zio.aws.emr.model.ShrinkPolicy.wrap(buildAwsValue())
}
object ShrinkPolicy {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.ShrinkPolicy] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ShrinkPolicy =
      zio.aws.emr.model.ShrinkPolicy(
        decommissionTimeout.map(value => value),
        instanceResizePolicy.map(value => value.asEditable)
      )
    def decommissionTimeout: Optional[Integer]
    def instanceResizePolicy
        : Optional[zio.aws.emr.model.InstanceResizePolicy.ReadOnly]
    def getDecommissionTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("decommissionTimeout", decommissionTimeout)
    def getInstanceResizePolicy
        : ZIO[Any, AwsError, zio.aws.emr.model.InstanceResizePolicy.ReadOnly] =
      AwsError.unwrapOptionField("instanceResizePolicy", instanceResizePolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ShrinkPolicy
  ) extends zio.aws.emr.model.ShrinkPolicy.ReadOnly {
    override val decommissionTimeout: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.decommissionTimeout())
      .map(value => value: Integer)
    override val instanceResizePolicy
        : Optional[zio.aws.emr.model.InstanceResizePolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceResizePolicy())
        .map(value => zio.aws.emr.model.InstanceResizePolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ShrinkPolicy
  ): zio.aws.emr.model.ShrinkPolicy.ReadOnly = new Wrapper(impl)
}
