package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SetTerminationProtectionRequest(
    jobFlowIds: Iterable[XmlString],
    terminationProtected: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.SetTerminationProtectionRequest = {
    import SetTerminationProtectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.SetTerminationProtectionRequest
      .builder()
      .jobFlowIds(jobFlowIds.map { item =>
        XmlString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .terminationProtected(terminationProtected: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.SetTerminationProtectionRequest.ReadOnly =
    zio.aws.emr.model.SetTerminationProtectionRequest.wrap(buildAwsValue())
}
object SetTerminationProtectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.SetTerminationProtectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.SetTerminationProtectionRequest =
      zio.aws.emr.model
        .SetTerminationProtectionRequest(jobFlowIds, terminationProtected)
    def jobFlowIds: List[XmlString]
    def terminationProtected: Boolean
    def getJobFlowIds: ZIO[Any, Nothing, List[XmlString]] =
      ZIO.succeed(jobFlowIds)
    def getTerminationProtected: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(terminationProtected)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.SetTerminationProtectionRequest
  ) extends zio.aws.emr.model.SetTerminationProtectionRequest.ReadOnly {
    override val jobFlowIds: List[XmlString] = impl
      .jobFlowIds()
      .asScala
      .map { item =>
        zio.aws.emr.model.primitives.XmlString(item)
      }
      .toList
    override val terminationProtected: Boolean =
      impl.terminationProtected(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.SetTerminationProtectionRequest
  ): zio.aws.emr.model.SetTerminationProtectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
