package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait InstanceState {
  def unwrap: software.amazon.awssdk.services.emr.model.InstanceState
}
object InstanceState {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.InstanceState
  ): zio.aws.emr.model.InstanceState = value match {
    case software.amazon.awssdk.services.emr.model.InstanceState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.InstanceState.AWAITING_FULFILLMENT =>
      val r = AWAITING_FULFILLMENT
      r
    case software.amazon.awssdk.services.emr.model.InstanceState.PROVISIONING =>
      val r = PROVISIONING
      r
    case software.amazon.awssdk.services.emr.model.InstanceState.BOOTSTRAPPING =>
      val r = BOOTSTRAPPING
      r
    case software.amazon.awssdk.services.emr.model.InstanceState.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.emr.model.InstanceState.TERMINATED =>
      val r = TERMINATED
      r
  }
  case object unknownToSdkVersion extends zio.aws.emr.model.InstanceState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceState =
      software.amazon.awssdk.services.emr.model.InstanceState.UNKNOWN_TO_SDK_VERSION
  }
  case object AWAITING_FULFILLMENT extends zio.aws.emr.model.InstanceState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceState =
      software.amazon.awssdk.services.emr.model.InstanceState.AWAITING_FULFILLMENT
  }
  case object PROVISIONING extends zio.aws.emr.model.InstanceState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceState =
      software.amazon.awssdk.services.emr.model.InstanceState.PROVISIONING
  }
  case object BOOTSTRAPPING extends zio.aws.emr.model.InstanceState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceState =
      software.amazon.awssdk.services.emr.model.InstanceState.BOOTSTRAPPING
  }
  case object RUNNING extends zio.aws.emr.model.InstanceState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceState =
      software.amazon.awssdk.services.emr.model.InstanceState.RUNNING
  }
  case object TERMINATED extends zio.aws.emr.model.InstanceState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceState =
      software.amazon.awssdk.services.emr.model.InstanceState.TERMINATED
  }
}
