package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ManagedScalingPolicy(
    computeLimits: Optional[zio.aws.emr.model.ComputeLimits] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ManagedScalingPolicy = {
    import ManagedScalingPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ManagedScalingPolicy
      .builder()
      .optionallyWith(computeLimits.map(value => value.buildAwsValue()))(
        _.computeLimits
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ManagedScalingPolicy.ReadOnly =
    zio.aws.emr.model.ManagedScalingPolicy.wrap(buildAwsValue())
}
object ManagedScalingPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ManagedScalingPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ManagedScalingPolicy = zio.aws.emr.model
      .ManagedScalingPolicy(computeLimits.map(value => value.asEditable))
    def computeLimits: Optional[zio.aws.emr.model.ComputeLimits.ReadOnly]
    def getComputeLimits
        : ZIO[Any, AwsError, zio.aws.emr.model.ComputeLimits.ReadOnly] =
      AwsError.unwrapOptionField("computeLimits", computeLimits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ManagedScalingPolicy
  ) extends zio.aws.emr.model.ManagedScalingPolicy.ReadOnly {
    override val computeLimits
        : Optional[zio.aws.emr.model.ComputeLimits.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computeLimits())
        .map(value => zio.aws.emr.model.ComputeLimits.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ManagedScalingPolicy
  ): zio.aws.emr.model.ManagedScalingPolicy.ReadOnly = new Wrapper(impl)
}
