package zio.aws.emr.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emr.model.primitives.{
  WholeNumber,
  XmlStringMaxLen256,
  InstanceFleetId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class InstanceFleet(
    id: Optional[InstanceFleetId] = Optional.Absent,
    name: Optional[XmlStringMaxLen256] = Optional.Absent,
    status: Optional[zio.aws.emr.model.InstanceFleetStatus] = Optional.Absent,
    instanceFleetType: Optional[zio.aws.emr.model.InstanceFleetType] =
      Optional.Absent,
    targetOnDemandCapacity: Optional[WholeNumber] = Optional.Absent,
    targetSpotCapacity: Optional[WholeNumber] = Optional.Absent,
    provisionedOnDemandCapacity: Optional[WholeNumber] = Optional.Absent,
    provisionedSpotCapacity: Optional[WholeNumber] = Optional.Absent,
    instanceTypeSpecifications: Optional[
      Iterable[zio.aws.emr.model.InstanceTypeSpecification]
    ] = Optional.Absent,
    launchSpecifications: Optional[
      zio.aws.emr.model.InstanceFleetProvisioningSpecifications
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.InstanceFleet = {
    import InstanceFleet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.InstanceFleet
      .builder()
      .optionallyWith(
        id.map(value => InstanceFleetId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => XmlStringMaxLen256.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(instanceFleetType.map(value => value.unwrap))(
        _.instanceFleetType
      )
      .optionallyWith(
        targetOnDemandCapacity.map(value => WholeNumber.unwrap(value): Integer)
      )(_.targetOnDemandCapacity)
      .optionallyWith(
        targetSpotCapacity.map(value => WholeNumber.unwrap(value): Integer)
      )(_.targetSpotCapacity)
      .optionallyWith(
        provisionedOnDemandCapacity.map(value =>
          WholeNumber.unwrap(value): Integer
        )
      )(_.provisionedOnDemandCapacity)
      .optionallyWith(
        provisionedSpotCapacity.map(value => WholeNumber.unwrap(value): Integer)
      )(_.provisionedSpotCapacity)
      .optionallyWith(
        instanceTypeSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceTypeSpecifications)
      .optionallyWith(launchSpecifications.map(value => value.buildAwsValue()))(
        _.launchSpecifications
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.InstanceFleet.ReadOnly =
    zio.aws.emr.model.InstanceFleet.wrap(buildAwsValue())
}
object InstanceFleet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.InstanceFleet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.InstanceFleet =
      zio.aws.emr.model.InstanceFleet(
        id.map(value => value),
        name.map(value => value),
        status.map(value => value.asEditable),
        instanceFleetType.map(value => value),
        targetOnDemandCapacity.map(value => value),
        targetSpotCapacity.map(value => value),
        provisionedOnDemandCapacity.map(value => value),
        provisionedSpotCapacity.map(value => value),
        instanceTypeSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        launchSpecifications.map(value => value.asEditable)
      )
    def id: Optional[InstanceFleetId]
    def name: Optional[XmlStringMaxLen256]
    def status: Optional[zio.aws.emr.model.InstanceFleetStatus.ReadOnly]
    def instanceFleetType: Optional[zio.aws.emr.model.InstanceFleetType]
    def targetOnDemandCapacity: Optional[WholeNumber]
    def targetSpotCapacity: Optional[WholeNumber]
    def provisionedOnDemandCapacity: Optional[WholeNumber]
    def provisionedSpotCapacity: Optional[WholeNumber]
    def instanceTypeSpecifications
        : Optional[List[zio.aws.emr.model.InstanceTypeSpecification.ReadOnly]]
    def launchSpecifications: Optional[
      zio.aws.emr.model.InstanceFleetProvisioningSpecifications.ReadOnly
    ]
    def getId: ZIO[Any, AwsError, InstanceFleetId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.emr.model.InstanceFleetStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
    def getInstanceFleetType
        : ZIO[Any, AwsError, zio.aws.emr.model.InstanceFleetType] =
      AwsError.unwrapOptionField("instanceFleetType", instanceFleetType)
    def getTargetOnDemandCapacity: ZIO[Any, AwsError, WholeNumber] = AwsError
      .unwrapOptionField("targetOnDemandCapacity", targetOnDemandCapacity)
    def getTargetSpotCapacity: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("targetSpotCapacity", targetSpotCapacity)
    def getProvisionedOnDemandCapacity: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField(
        "provisionedOnDemandCapacity",
        provisionedOnDemandCapacity
      )
    def getProvisionedSpotCapacity: ZIO[Any, AwsError, WholeNumber] = AwsError
      .unwrapOptionField("provisionedSpotCapacity", provisionedSpotCapacity)
    def getInstanceTypeSpecifications: ZIO[Any, AwsError, List[
      zio.aws.emr.model.InstanceTypeSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "instanceTypeSpecifications",
      instanceTypeSpecifications
    )
    def getLaunchSpecifications: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.InstanceFleetProvisioningSpecifications.ReadOnly
    ] = AwsError.unwrapOptionField("launchSpecifications", launchSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.InstanceFleet
  ) extends zio.aws.emr.model.InstanceFleet.ReadOnly {
    override val id: Optional[InstanceFleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.emr.model.primitives.InstanceFleetId(value))
    override val name: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val status
        : Optional[zio.aws.emr.model.InstanceFleetStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.emr.model.InstanceFleetStatus.wrap(value))
    override val instanceFleetType
        : Optional[zio.aws.emr.model.InstanceFleetType] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceFleetType())
      .map(value => zio.aws.emr.model.InstanceFleetType.wrap(value))
    override val targetOnDemandCapacity: Optional[WholeNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetOnDemandCapacity())
        .map(value => zio.aws.emr.model.primitives.WholeNumber(value))
    override val targetSpotCapacity: Optional[WholeNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetSpotCapacity())
        .map(value => zio.aws.emr.model.primitives.WholeNumber(value))
    override val provisionedOnDemandCapacity: Optional[WholeNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedOnDemandCapacity())
        .map(value => zio.aws.emr.model.primitives.WholeNumber(value))
    override val provisionedSpotCapacity: Optional[WholeNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedSpotCapacity())
        .map(value => zio.aws.emr.model.primitives.WholeNumber(value))
    override val instanceTypeSpecifications
        : Optional[List[zio.aws.emr.model.InstanceTypeSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceTypeSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.InstanceTypeSpecification.wrap(item)
          }.toList
        )
    override val launchSpecifications: Optional[
      zio.aws.emr.model.InstanceFleetProvisioningSpecifications.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.launchSpecifications())
      .map(value =>
        zio.aws.emr.model.InstanceFleetProvisioningSpecifications.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.InstanceFleet
  ): zio.aws.emr.model.InstanceFleet.ReadOnly = new Wrapper(impl)
}
