package zio.aws.emr.model
import zio.aws.emr.model.primitives.{InstanceType, InstanceFleetId, InstanceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Instance(
    id: Optional[InstanceId] = Optional.Absent,
    ec2InstanceId: Optional[InstanceId] = Optional.Absent,
    publicDnsName: Optional[String] = Optional.Absent,
    publicIpAddress: Optional[String] = Optional.Absent,
    privateDnsName: Optional[String] = Optional.Absent,
    privateIpAddress: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.emr.model.InstanceStatus] = Optional.Absent,
    instanceGroupId: Optional[String] = Optional.Absent,
    instanceFleetId: Optional[InstanceFleetId] = Optional.Absent,
    market: Optional[zio.aws.emr.model.MarketType] = Optional.Absent,
    instanceType: Optional[InstanceType] = Optional.Absent,
    ebsVolumes: Optional[Iterable[zio.aws.emr.model.EbsVolume]] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.emr.model.Instance = {
    import Instance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.Instance
      .builder()
      .optionallyWith(
        id.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        ec2InstanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.ec2InstanceId)
      .optionallyWith(publicDnsName.map(value => value: java.lang.String))(
        _.publicDnsName
      )
      .optionallyWith(publicIpAddress.map(value => value: java.lang.String))(
        _.publicIpAddress
      )
      .optionallyWith(privateDnsName.map(value => value: java.lang.String))(
        _.privateDnsName
      )
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(instanceGroupId.map(value => value: java.lang.String))(
        _.instanceGroupId
      )
      .optionallyWith(
        instanceFleetId.map(value =>
          InstanceFleetId.unwrap(value): java.lang.String
        )
      )(_.instanceFleetId)
      .optionallyWith(market.map(value => value.unwrap))(_.market)
      .optionallyWith(
        instanceType.map(value => InstanceType.unwrap(value): java.lang.String)
      )(_.instanceType)
      .optionallyWith(
        ebsVolumes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ebsVolumes)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.Instance.ReadOnly =
    zio.aws.emr.model.Instance.wrap(buildAwsValue())
}
object Instance {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.Instance] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.Instance = zio.aws.emr.model.Instance(
      id.map(value => value),
      ec2InstanceId.map(value => value),
      publicDnsName.map(value => value),
      publicIpAddress.map(value => value),
      privateDnsName.map(value => value),
      privateIpAddress.map(value => value),
      status.map(value => value.asEditable),
      instanceGroupId.map(value => value),
      instanceFleetId.map(value => value),
      market.map(value => value),
      instanceType.map(value => value),
      ebsVolumes.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def id: Optional[InstanceId]
    def ec2InstanceId: Optional[InstanceId]
    def publicDnsName: Optional[String]
    def publicIpAddress: Optional[String]
    def privateDnsName: Optional[String]
    def privateIpAddress: Optional[String]
    def status: Optional[zio.aws.emr.model.InstanceStatus.ReadOnly]
    def instanceGroupId: Optional[String]
    def instanceFleetId: Optional[InstanceFleetId]
    def market: Optional[zio.aws.emr.model.MarketType]
    def instanceType: Optional[InstanceType]
    def ebsVolumes: Optional[List[zio.aws.emr.model.EbsVolume.ReadOnly]]
    def getId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("id", id)
    def getEc2InstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("ec2InstanceId", ec2InstanceId)
    def getPublicDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicDnsName", publicDnsName)
    def getPublicIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicIpAddress", publicIpAddress)
    def getPrivateDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateDnsName", privateDnsName)
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.emr.model.InstanceStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
    def getInstanceGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceGroupId", instanceGroupId)
    def getInstanceFleetId: ZIO[Any, AwsError, InstanceFleetId] =
      AwsError.unwrapOptionField("instanceFleetId", instanceFleetId)
    def getMarket: ZIO[Any, AwsError, zio.aws.emr.model.MarketType] =
      AwsError.unwrapOptionField("market", market)
    def getInstanceType: ZIO[Any, AwsError, InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getEbsVolumes
        : ZIO[Any, AwsError, List[zio.aws.emr.model.EbsVolume.ReadOnly]] =
      AwsError.unwrapOptionField("ebsVolumes", ebsVolumes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.Instance
  ) extends zio.aws.emr.model.Instance.ReadOnly {
    override val id: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.emr.model.primitives.InstanceId(value))
    override val ec2InstanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.ec2InstanceId())
      .map(value => zio.aws.emr.model.primitives.InstanceId(value))
    override val publicDnsName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.publicDnsName())
      .map(value => value: String)
    override val publicIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.publicIpAddress())
      .map(value => value: String)
    override val privateDnsName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateDnsName())
      .map(value => value: String)
    override val privateIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateIpAddress())
      .map(value => value: String)
    override val status: Optional[zio.aws.emr.model.InstanceStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.emr.model.InstanceStatus.wrap(value))
    override val instanceGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceGroupId())
      .map(value => value: String)
    override val instanceFleetId: Optional[InstanceFleetId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceFleetId())
        .map(value => zio.aws.emr.model.primitives.InstanceFleetId(value))
    override val market: Optional[zio.aws.emr.model.MarketType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.market())
        .map(value => zio.aws.emr.model.MarketType.wrap(value))
    override val instanceType: Optional[InstanceType] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => zio.aws.emr.model.primitives.InstanceType(value))
    override val ebsVolumes
        : Optional[List[zio.aws.emr.model.EbsVolume.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebsVolumes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.EbsVolume.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.Instance
  ): zio.aws.emr.model.Instance.ReadOnly = new Wrapper(impl)
}
