package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetBlockPublicAccessConfigurationResponse(
    blockPublicAccessConfiguration: zio.aws.emr.model.BlockPublicAccessConfiguration,
    blockPublicAccessConfigurationMetadata: zio.aws.emr.model.BlockPublicAccessConfigurationMetadata
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.GetBlockPublicAccessConfigurationResponse = {
    import GetBlockPublicAccessConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.GetBlockPublicAccessConfigurationResponse
      .builder()
      .blockPublicAccessConfiguration(
        blockPublicAccessConfiguration.buildAwsValue()
      )
      .blockPublicAccessConfigurationMetadata(
        blockPublicAccessConfigurationMetadata.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.emr.model.GetBlockPublicAccessConfigurationResponse.ReadOnly =
    zio.aws.emr.model.GetBlockPublicAccessConfigurationResponse
      .wrap(buildAwsValue())
}
object GetBlockPublicAccessConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.GetBlockPublicAccessConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.emr.model.GetBlockPublicAccessConfigurationResponse =
      zio.aws.emr.model.GetBlockPublicAccessConfigurationResponse(
        blockPublicAccessConfiguration.asEditable,
        blockPublicAccessConfigurationMetadata.asEditable
      )
    def blockPublicAccessConfiguration
        : zio.aws.emr.model.BlockPublicAccessConfiguration.ReadOnly
    def blockPublicAccessConfigurationMetadata
        : zio.aws.emr.model.BlockPublicAccessConfigurationMetadata.ReadOnly
    def getBlockPublicAccessConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.emr.model.BlockPublicAccessConfiguration.ReadOnly
    ] = ZIO.succeed(blockPublicAccessConfiguration)
    def getBlockPublicAccessConfigurationMetadata: ZIO[
      Any,
      Nothing,
      zio.aws.emr.model.BlockPublicAccessConfigurationMetadata.ReadOnly
    ] = ZIO.succeed(blockPublicAccessConfigurationMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.GetBlockPublicAccessConfigurationResponse
  ) extends zio.aws.emr.model.GetBlockPublicAccessConfigurationResponse.ReadOnly {
    override val blockPublicAccessConfiguration
        : zio.aws.emr.model.BlockPublicAccessConfiguration.ReadOnly =
      zio.aws.emr.model.BlockPublicAccessConfiguration
        .wrap(impl.blockPublicAccessConfiguration())
    override val blockPublicAccessConfigurationMetadata
        : zio.aws.emr.model.BlockPublicAccessConfigurationMetadata.ReadOnly =
      zio.aws.emr.model.BlockPublicAccessConfigurationMetadata
        .wrap(impl.blockPublicAccessConfigurationMetadata())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.GetBlockPublicAccessConfigurationResponse
  ): zio.aws.emr.model.GetBlockPublicAccessConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
