package zio.aws.emr.model
import zio.aws.emr.model.primitives.ClusterId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetAutoTerminationPolicyRequest(clusterId: ClusterId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.GetAutoTerminationPolicyRequest = {
    import GetAutoTerminationPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.GetAutoTerminationPolicyRequest
      .builder()
      .clusterId(ClusterId.unwrap(clusterId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.GetAutoTerminationPolicyRequest.ReadOnly =
    zio.aws.emr.model.GetAutoTerminationPolicyRequest.wrap(buildAwsValue())
}
object GetAutoTerminationPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.GetAutoTerminationPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.GetAutoTerminationPolicyRequest =
      zio.aws.emr.model.GetAutoTerminationPolicyRequest(clusterId)
    def clusterId: ClusterId
    def getClusterId: ZIO[Any, Nothing, ClusterId] = ZIO.succeed(clusterId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.GetAutoTerminationPolicyRequest
  ) extends zio.aws.emr.model.GetAutoTerminationPolicyRequest.ReadOnly {
    override val clusterId: ClusterId =
      zio.aws.emr.model.primitives.ClusterId(impl.clusterId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.GetAutoTerminationPolicyRequest
  ): zio.aws.emr.model.GetAutoTerminationPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
