package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeReleaseLabelResponse(
    releaseLabel: Optional[String] = Optional.Absent,
    applications: Optional[Iterable[zio.aws.emr.model.SimplifiedApplication]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.DescribeReleaseLabelResponse = {
    import DescribeReleaseLabelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.DescribeReleaseLabelResponse
      .builder()
      .optionallyWith(releaseLabel.map(value => value: java.lang.String))(
        _.releaseLabel
      )
      .optionallyWith(
        applications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applications)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.DescribeReleaseLabelResponse.ReadOnly =
    zio.aws.emr.model.DescribeReleaseLabelResponse.wrap(buildAwsValue())
}
object DescribeReleaseLabelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.DescribeReleaseLabelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.DescribeReleaseLabelResponse =
      zio.aws.emr.model.DescribeReleaseLabelResponse(
        releaseLabel.map(value => value),
        applications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def releaseLabel: Optional[String]
    def applications
        : Optional[List[zio.aws.emr.model.SimplifiedApplication.ReadOnly]]
    def nextToken: Optional[String]
    def getReleaseLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("releaseLabel", releaseLabel)
    def getApplications: ZIO[Any, AwsError, List[
      zio.aws.emr.model.SimplifiedApplication.ReadOnly
    ]] = AwsError.unwrapOptionField("applications", applications)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.DescribeReleaseLabelResponse
  ) extends zio.aws.emr.model.DescribeReleaseLabelResponse.ReadOnly {
    override val releaseLabel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.releaseLabel())
      .map(value => value: String)
    override val applications
        : Optional[List[zio.aws.emr.model.SimplifiedApplication.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.SimplifiedApplication.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.DescribeReleaseLabelResponse
  ): zio.aws.emr.model.DescribeReleaseLabelResponse.ReadOnly = new Wrapper(impl)
}
