package zio.aws.emr
import zio.aws.emr.model.PutManagedScalingPolicyResponse.ReadOnly
import software.amazon.awssdk.services.emr.{
  EmrAsyncClientBuilder,
  EmrAsyncClient
}
import zio.aws.core.config.AwsConfig
import zio.aws.emr.model.{
  RunJobFlowRequest,
  AddInstanceGroupsRequest,
  ListNotebookExecutionsRequest,
  AddInstanceFleetRequest,
  PutBlockPublicAccessConfigurationRequest,
  RemoveManagedScalingPolicyRequest,
  DeleteSecurityConfigurationRequest,
  CreateStudioRequest,
  ListBootstrapActionsRequest,
  GetAutoTerminationPolicyRequest,
  StartNotebookExecutionRequest,
  ListInstancesRequest,
  PutManagedScalingPolicyRequest,
  SetTerminationProtectionRequest,
  DescribeSecurityConfigurationRequest,
  ListStepsRequest,
  UpdateStudioSessionMappingRequest,
  DescribeStepRequest,
  PutAutoTerminationPolicyRequest,
  SetVisibleToAllUsersRequest,
  AddTagsRequest,
  GetBlockPublicAccessConfigurationRequest,
  UpdateStudioRequest,
  TerminateJobFlowsRequest,
  ModifyInstanceGroupsRequest,
  CancelStepsRequest,
  ListStudiosRequest,
  RemoveAutoScalingPolicyRequest,
  RemoveAutoTerminationPolicyRequest,
  DeleteStudioSessionMappingRequest,
  PutAutoScalingPolicyRequest,
  ModifyInstanceFleetRequest,
  ListInstanceGroupsRequest,
  StopNotebookExecutionRequest,
  DescribeClusterRequest,
  ListReleaseLabelsRequest,
  GetStudioSessionMappingRequest,
  DescribeReleaseLabelRequest,
  ListStudioSessionMappingsRequest,
  AddJobFlowStepsRequest,
  ModifyClusterRequest,
  DescribeStudioRequest,
  ListSecurityConfigurationsRequest,
  DescribeNotebookExecutionRequest,
  RemoveTagsRequest,
  GetManagedScalingPolicyRequest,
  ListClustersRequest,
  CreateSecurityConfigurationRequest,
  CreateStudioSessionMappingRequest,
  ListInstanceFleetsRequest,
  DeleteStudioRequest
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.emr.model.{
  ListStudioSessionMappingsResponse,
  ListInstancesResponse,
  ListStepsResponse,
  Instance,
  DescribeStudioResponse,
  RemoveAutoScalingPolicyResponse,
  DescribeStepResponse,
  DeleteSecurityConfigurationResponse,
  PutAutoScalingPolicyResponse,
  StudioSummary,
  GetAutoTerminationPolicyResponse,
  CreateStudioSessionMappingResponse,
  SessionMappingSummary,
  ListSecurityConfigurationsResponse,
  RunJobFlowResponse,
  AddInstanceGroupsResponse,
  AddInstanceFleetResponse,
  SecurityConfigurationSummary,
  CreateSecurityConfigurationResponse,
  ModifyInstanceFleetResponse,
  CreateStudioResponse,
  DescribeSecurityConfigurationResponse,
  RemoveTagsResponse,
  RemoveManagedScalingPolicyResponse,
  TerminateJobFlowsResponse,
  PutAutoTerminationPolicyResponse,
  NotebookExecutionSummary,
  SetTerminationProtectionResponse,
  AddJobFlowStepsResponse,
  StepSummary,
  StartNotebookExecutionResponse,
  InstanceFleet,
  CancelStepsResponse,
  InstanceGroup,
  DescribeClusterResponse,
  SimplifiedApplication,
  UpdateStudioSessionMappingResponse,
  DeleteStudioResponse,
  ListReleaseLabelsResponse,
  ListNotebookExecutionsResponse,
  ModifyInstanceGroupsResponse,
  GetManagedScalingPolicyResponse,
  ListInstanceFleetsResponse,
  PutBlockPublicAccessConfigurationResponse,
  AddTagsResponse,
  ListBootstrapActionsResponse,
  RemoveAutoTerminationPolicyResponse,
  DeleteStudioSessionMappingResponse,
  UpdateStudioResponse,
  Command,
  ListStudiosResponse,
  PutManagedScalingPolicyResponse,
  DescribeReleaseLabelResponse,
  DescribeNotebookExecutionResponse,
  ClusterSummary,
  StopNotebookExecutionResponse,
  GetBlockPublicAccessConfigurationResponse,
  ListInstanceGroupsResponse,
  SetVisibleToAllUsersResponse,
  GetStudioSessionMappingResponse,
  ModifyClusterResponse,
  ListClustersResponse
}
import zio.stream.ZStream
import software.amazon.awssdk.services.emr.paginators.{
  ListInstancesPublisher,
  ListNotebookExecutionsPublisher,
  ListSecurityConfigurationsPublisher,
  ListStepsPublisher,
  ListStudiosPublisher,
  ListInstanceGroupsPublisher,
  ListStudioSessionMappingsPublisher,
  ListInstanceFleetsPublisher,
  ListBootstrapActionsPublisher,
  ListClustersPublisher
}
import scala.jdk.CollectionConverters._
trait Emr extends AspectSupport[Emr] {
  val api: EmrAsyncClient
  def getBlockPublicAccessConfiguration(
      request: GetBlockPublicAccessConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.emr.model.GetBlockPublicAccessConfigurationResponse.ReadOnly
  ]
  def listStudioSessionMappings(
      request: ListStudioSessionMappingsRequest
  ): ZStream[Any, AwsError, zio.aws.emr.model.SessionMappingSummary.ReadOnly]
  def listStudioSessionMappingsPaginated(
      request: ListStudioSessionMappingsRequest
  ): IO[AwsError, zio.aws.emr.model.ListStudioSessionMappingsResponse.ReadOnly]
  def createStudio(
      request: CreateStudioRequest
  ): IO[AwsError, zio.aws.emr.model.CreateStudioResponse.ReadOnly]
  def describeNotebookExecution(
      request: DescribeNotebookExecutionRequest
  ): IO[AwsError, zio.aws.emr.model.DescribeNotebookExecutionResponse.ReadOnly]
  def stopNotebookExecution(
      request: StopNotebookExecutionRequest
  ): IO[AwsError, Unit]
  def listBootstrapActions(
      request: ListBootstrapActionsRequest
  ): ZStream[Any, AwsError, zio.aws.emr.model.Command.ReadOnly]
  def listBootstrapActionsPaginated(
      request: ListBootstrapActionsRequest
  ): IO[AwsError, zio.aws.emr.model.ListBootstrapActionsResponse.ReadOnly]
  def listReleaseLabels(
      request: ListReleaseLabelsRequest
  ): ZStream[Any, AwsError, String]
  def listReleaseLabelsPaginated(
      request: ListReleaseLabelsRequest
  ): IO[AwsError, zio.aws.emr.model.ListReleaseLabelsResponse.ReadOnly]
  def setTerminationProtection(
      request: SetTerminationProtectionRequest
  ): IO[AwsError, Unit]
  def describeStep(
      request: DescribeStepRequest
  ): IO[AwsError, zio.aws.emr.model.DescribeStepResponse.ReadOnly]
  def cancelSteps(
      request: CancelStepsRequest
  ): IO[AwsError, zio.aws.emr.model.CancelStepsResponse.ReadOnly]
  def listInstances(
      request: ListInstancesRequest
  ): ZStream[Any, AwsError, zio.aws.emr.model.Instance.ReadOnly]
  def listInstancesPaginated(
      request: ListInstancesRequest
  ): IO[AwsError, zio.aws.emr.model.ListInstancesResponse.ReadOnly]
  def describeStudio(
      request: DescribeStudioRequest
  ): IO[AwsError, zio.aws.emr.model.DescribeStudioResponse.ReadOnly]
  def addTags(
      request: AddTagsRequest
  ): IO[AwsError, zio.aws.emr.model.AddTagsResponse.ReadOnly]
  def putAutoScalingPolicy(
      request: PutAutoScalingPolicyRequest
  ): IO[AwsError, zio.aws.emr.model.PutAutoScalingPolicyResponse.ReadOnly]
  def removeAutoScalingPolicy(
      request: RemoveAutoScalingPolicyRequest
  ): IO[AwsError, zio.aws.emr.model.RemoveAutoScalingPolicyResponse.ReadOnly]
  def setVisibleToAllUsers(
      request: SetVisibleToAllUsersRequest
  ): IO[AwsError, Unit]
  def getStudioSessionMapping(
      request: GetStudioSessionMappingRequest
  ): IO[AwsError, zio.aws.emr.model.GetStudioSessionMappingResponse.ReadOnly]
  def listSecurityConfigurations(
      request: ListSecurityConfigurationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.emr.model.SecurityConfigurationSummary.ReadOnly
  ]
  def listSecurityConfigurationsPaginated(
      request: ListSecurityConfigurationsRequest
  ): IO[AwsError, zio.aws.emr.model.ListSecurityConfigurationsResponse.ReadOnly]
  def deleteStudioSessionMapping(
      request: DeleteStudioSessionMappingRequest
  ): IO[AwsError, Unit]
  def putAutoTerminationPolicy(
      request: PutAutoTerminationPolicyRequest
  ): IO[AwsError, zio.aws.emr.model.PutAutoTerminationPolicyResponse.ReadOnly]
  def modifyInstanceFleet(
      request: ModifyInstanceFleetRequest
  ): IO[AwsError, Unit]
  def removeTags(
      request: RemoveTagsRequest
  ): IO[AwsError, zio.aws.emr.model.RemoveTagsResponse.ReadOnly]
  def listInstanceGroups(
      request: ListInstanceGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.emr.model.InstanceGroup.ReadOnly]
  def listInstanceGroupsPaginated(
      request: ListInstanceGroupsRequest
  ): IO[AwsError, zio.aws.emr.model.ListInstanceGroupsResponse.ReadOnly]
  def getAutoTerminationPolicy(
      request: GetAutoTerminationPolicyRequest
  ): IO[AwsError, zio.aws.emr.model.GetAutoTerminationPolicyResponse.ReadOnly]
  def updateStudioSessionMapping(
      request: UpdateStudioSessionMappingRequest
  ): IO[AwsError, Unit]
  def putBlockPublicAccessConfiguration(
      request: PutBlockPublicAccessConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.emr.model.PutBlockPublicAccessConfigurationResponse.ReadOnly
  ]
  def updateStudio(request: UpdateStudioRequest): IO[AwsError, Unit]
  def putManagedScalingPolicy(
      request: PutManagedScalingPolicyRequest
  ): IO[AwsError, ReadOnly]
  def listSteps(
      request: ListStepsRequest
  ): ZStream[Any, AwsError, zio.aws.emr.model.StepSummary.ReadOnly]
  def listStepsPaginated(
      request: ListStepsRequest
  ): IO[AwsError, zio.aws.emr.model.ListStepsResponse.ReadOnly]
  def listStudios(
      request: ListStudiosRequest
  ): ZStream[Any, AwsError, zio.aws.emr.model.StudioSummary.ReadOnly]
  def listStudiosPaginated(
      request: ListStudiosRequest
  ): IO[AwsError, zio.aws.emr.model.ListStudiosResponse.ReadOnly]
  def addJobFlowSteps(
      request: AddJobFlowStepsRequest
  ): IO[AwsError, zio.aws.emr.model.AddJobFlowStepsResponse.ReadOnly]
  def createSecurityConfiguration(
      request: CreateSecurityConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.emr.model.CreateSecurityConfigurationResponse.ReadOnly
  ]
  def addInstanceFleet(
      request: AddInstanceFleetRequest
  ): IO[AwsError, zio.aws.emr.model.AddInstanceFleetResponse.ReadOnly]
  def modifyCluster(
      request: ModifyClusterRequest
  ): IO[AwsError, zio.aws.emr.model.ModifyClusterResponse.ReadOnly]
  def deleteSecurityConfiguration(
      request: DeleteSecurityConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.emr.model.DeleteSecurityConfigurationResponse.ReadOnly
  ]
  def createStudioSessionMapping(
      request: CreateStudioSessionMappingRequest
  ): IO[AwsError, Unit]
  def describeSecurityConfiguration(
      request: DescribeSecurityConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.emr.model.DescribeSecurityConfigurationResponse.ReadOnly
  ]
  def describeCluster(
      request: DescribeClusterRequest
  ): IO[AwsError, zio.aws.emr.model.DescribeClusterResponse.ReadOnly]
  def listClusters(
      request: ListClustersRequest
  ): ZStream[Any, AwsError, zio.aws.emr.model.ClusterSummary.ReadOnly]
  def listClustersPaginated(
      request: ListClustersRequest
  ): IO[AwsError, zio.aws.emr.model.ListClustersResponse.ReadOnly]
  def addInstanceGroups(
      request: AddInstanceGroupsRequest
  ): IO[AwsError, zio.aws.emr.model.AddInstanceGroupsResponse.ReadOnly]
  def deleteStudio(request: DeleteStudioRequest): IO[AwsError, Unit]
  def runJobFlow(
      request: RunJobFlowRequest
  ): IO[AwsError, zio.aws.emr.model.RunJobFlowResponse.ReadOnly]
  def removeAutoTerminationPolicy(
      request: RemoveAutoTerminationPolicyRequest
  ): IO[
    AwsError,
    zio.aws.emr.model.RemoveAutoTerminationPolicyResponse.ReadOnly
  ]
  def describeReleaseLabel(
      request: DescribeReleaseLabelRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.emr.model.DescribeReleaseLabelResponse.ReadOnly,
    zio.aws.emr.model.SimplifiedApplication.ReadOnly
  ]]
  def describeReleaseLabelPaginated(
      request: DescribeReleaseLabelRequest
  ): IO[AwsError, zio.aws.emr.model.DescribeReleaseLabelResponse.ReadOnly]
  def startNotebookExecution(
      request: StartNotebookExecutionRequest
  ): IO[AwsError, zio.aws.emr.model.StartNotebookExecutionResponse.ReadOnly]
  def removeManagedScalingPolicy(
      request: RemoveManagedScalingPolicyRequest
  ): IO[AwsError, zio.aws.emr.model.RemoveManagedScalingPolicyResponse.ReadOnly]
  def modifyInstanceGroups(
      request: ModifyInstanceGroupsRequest
  ): IO[AwsError, Unit]
  def listNotebookExecutions(
      request: ListNotebookExecutionsRequest
  ): ZStream[Any, AwsError, zio.aws.emr.model.NotebookExecutionSummary.ReadOnly]
  def listNotebookExecutionsPaginated(
      request: ListNotebookExecutionsRequest
  ): IO[AwsError, zio.aws.emr.model.ListNotebookExecutionsResponse.ReadOnly]
  def terminateJobFlows(request: TerminateJobFlowsRequest): IO[AwsError, Unit]
  def listInstanceFleets(
      request: ListInstanceFleetsRequest
  ): ZStream[Any, AwsError, zio.aws.emr.model.InstanceFleet.ReadOnly]
  def listInstanceFleetsPaginated(
      request: ListInstanceFleetsRequest
  ): IO[AwsError, zio.aws.emr.model.ListInstanceFleetsResponse.ReadOnly]
  def getManagedScalingPolicy(
      request: GetManagedScalingPolicyRequest
  ): IO[AwsError, zio.aws.emr.model.GetManagedScalingPolicyResponse.ReadOnly]
}
object Emr {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Emr] = customized(identity)
  def customized(
      customization: EmrAsyncClientBuilder => EmrAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Emr] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: EmrAsyncClientBuilder => EmrAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Emr] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = EmrAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[EmrAsyncClient, EmrAsyncClientBuilder](builder);
    b1 <- awsConfig.configureHttpClient[EmrAsyncClient, EmrAsyncClientBuilder](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  ) yield new EmrImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class EmrImpl[R](
      override val api: EmrAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Emr
      with AwsServiceBase[R] {
    override val serviceName: String = "Emr"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): EmrImpl[R1] = new EmrImpl(api, newAspect, r)
    def getBlockPublicAccessConfiguration(
        request: GetBlockPublicAccessConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.emr.model.GetBlockPublicAccessConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.emr.model.GetBlockPublicAccessConfigurationRequest,
      GetBlockPublicAccessConfigurationResponse
    ](
      "getBlockPublicAccessConfiguration",
      api.getBlockPublicAccessConfiguration
    )(request.buildAwsValue())
      .map(zio.aws.emr.model.GetBlockPublicAccessConfigurationResponse.wrap)
      .provideEnvironment(r)
    def listStudioSessionMappings(
        request: ListStudioSessionMappingsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.emr.model.SessionMappingSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsRequest,
      SessionMappingSummary,
      ListStudioSessionMappingsPublisher
    ](
      "listStudioSessionMappings",
      api.listStudioSessionMappingsPaginator,
      _.sessionMappings()
    )(request.buildAwsValue())
      .map(item => zio.aws.emr.model.SessionMappingSummary.wrap(item))
      .provideEnvironment(r)
    def listStudioSessionMappingsPaginated(
        request: ListStudioSessionMappingsRequest
    ): IO[
      AwsError,
      zio.aws.emr.model.ListStudioSessionMappingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsRequest,
      ListStudioSessionMappingsResponse
    ]("listStudioSessionMappings", api.listStudioSessionMappings)(
      request.buildAwsValue()
    ).map(zio.aws.emr.model.ListStudioSessionMappingsResponse.wrap)
      .provideEnvironment(r)
    def createStudio(
        request: CreateStudioRequest
    ): IO[AwsError, zio.aws.emr.model.CreateStudioResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.emr.model.CreateStudioRequest,
        CreateStudioResponse
      ]("createStudio", api.createStudio)(request.buildAwsValue())
        .map(zio.aws.emr.model.CreateStudioResponse.wrap)
        .provideEnvironment(r)
    def describeNotebookExecution(
        request: DescribeNotebookExecutionRequest
    ): IO[
      AwsError,
      zio.aws.emr.model.DescribeNotebookExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.emr.model.DescribeNotebookExecutionRequest,
      DescribeNotebookExecutionResponse
    ]("describeNotebookExecution", api.describeNotebookExecution)(
      request.buildAwsValue()
    ).map(zio.aws.emr.model.DescribeNotebookExecutionResponse.wrap)
      .provideEnvironment(r)
    def stopNotebookExecution(
        request: StopNotebookExecutionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.emr.model.StopNotebookExecutionRequest,
      StopNotebookExecutionResponse
    ]("stopNotebookExecution", api.stopNotebookExecution)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listBootstrapActions(
        request: ListBootstrapActionsRequest
    ): ZStream[Any, AwsError, zio.aws.emr.model.Command.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.emr.model.ListBootstrapActionsRequest,
        Command,
        ListBootstrapActionsPublisher
      ](
        "listBootstrapActions",
        api.listBootstrapActionsPaginator,
        _.bootstrapActions()
      )(request.buildAwsValue())
        .map(item => zio.aws.emr.model.Command.wrap(item))
        .provideEnvironment(r)
    def listBootstrapActionsPaginated(
        request: ListBootstrapActionsRequest
    ): IO[AwsError, zio.aws.emr.model.ListBootstrapActionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.emr.model.ListBootstrapActionsRequest,
        ListBootstrapActionsResponse
      ]("listBootstrapActions", api.listBootstrapActions)(
        request.buildAwsValue()
      ).map(zio.aws.emr.model.ListBootstrapActionsResponse.wrap)
        .provideEnvironment(r)
    def listReleaseLabels(
        request: ListReleaseLabelsRequest
    ): ZStream[Any, AwsError, String] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.emr.model.ListReleaseLabelsRequest,
      ListReleaseLabelsResponse,
      java.lang.String
    ](
      "listReleaseLabels",
      api.listReleaseLabels,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.releaseLabels().asScala)
    )(request.buildAwsValue()).map(item => item: String).provideEnvironment(r)
    def listReleaseLabelsPaginated(
        request: ListReleaseLabelsRequest
    ): IO[AwsError, zio.aws.emr.model.ListReleaseLabelsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.emr.model.ListReleaseLabelsRequest,
        ListReleaseLabelsResponse
      ]("listReleaseLabels", api.listReleaseLabels)(request.buildAwsValue())
        .map(zio.aws.emr.model.ListReleaseLabelsResponse.wrap)
        .provideEnvironment(r)
    def setTerminationProtection(
        request: SetTerminationProtectionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.emr.model.SetTerminationProtectionRequest,
      SetTerminationProtectionResponse
    ]("setTerminationProtection", api.setTerminationProtection)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeStep(
        request: DescribeStepRequest
    ): IO[AwsError, zio.aws.emr.model.DescribeStepResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.emr.model.DescribeStepRequest,
        DescribeStepResponse
      ]("describeStep", api.describeStep)(request.buildAwsValue())
        .map(zio.aws.emr.model.DescribeStepResponse.wrap)
        .provideEnvironment(r)
    def cancelSteps(
        request: CancelStepsRequest
    ): IO[AwsError, zio.aws.emr.model.CancelStepsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.emr.model.CancelStepsRequest,
        CancelStepsResponse
      ]("cancelSteps", api.cancelSteps)(request.buildAwsValue())
        .map(zio.aws.emr.model.CancelStepsResponse.wrap)
        .provideEnvironment(r)
    def listInstances(
        request: ListInstancesRequest
    ): ZStream[Any, AwsError, zio.aws.emr.model.Instance.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.emr.model.ListInstancesRequest,
        Instance,
        ListInstancesPublisher
      ]("listInstances", api.listInstancesPaginator, _.instances())(
        request.buildAwsValue()
      ).map(item => zio.aws.emr.model.Instance.wrap(item)).provideEnvironment(r)
    def listInstancesPaginated(
        request: ListInstancesRequest
    ): IO[AwsError, zio.aws.emr.model.ListInstancesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.emr.model.ListInstancesRequest,
        ListInstancesResponse
      ]("listInstances", api.listInstances)(request.buildAwsValue())
        .map(zio.aws.emr.model.ListInstancesResponse.wrap)
        .provideEnvironment(r)
    def describeStudio(
        request: DescribeStudioRequest
    ): IO[AwsError, zio.aws.emr.model.DescribeStudioResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.emr.model.DescribeStudioRequest,
        DescribeStudioResponse
      ]("describeStudio", api.describeStudio)(request.buildAwsValue())
        .map(zio.aws.emr.model.DescribeStudioResponse.wrap)
        .provideEnvironment(r)
    def addTags(
        request: AddTagsRequest
    ): IO[AwsError, zio.aws.emr.model.AddTagsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.emr.model.AddTagsRequest,
        AddTagsResponse
      ]("addTags", api.addTags)(request.buildAwsValue())
        .map(zio.aws.emr.model.AddTagsResponse.wrap)
        .provideEnvironment(r)
    def putAutoScalingPolicy(
        request: PutAutoScalingPolicyRequest
    ): IO[AwsError, zio.aws.emr.model.PutAutoScalingPolicyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.emr.model.PutAutoScalingPolicyRequest,
        PutAutoScalingPolicyResponse
      ]("putAutoScalingPolicy", api.putAutoScalingPolicy)(
        request.buildAwsValue()
      ).map(zio.aws.emr.model.PutAutoScalingPolicyResponse.wrap)
        .provideEnvironment(r)
    def removeAutoScalingPolicy(request: RemoveAutoScalingPolicyRequest): IO[
      AwsError,
      zio.aws.emr.model.RemoveAutoScalingPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.emr.model.RemoveAutoScalingPolicyRequest,
      RemoveAutoScalingPolicyResponse
    ]("removeAutoScalingPolicy", api.removeAutoScalingPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.emr.model.RemoveAutoScalingPolicyResponse.wrap)
      .provideEnvironment(r)
    def setVisibleToAllUsers(
        request: SetVisibleToAllUsersRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.emr.model.SetVisibleToAllUsersRequest,
      SetVisibleToAllUsersResponse
    ]("setVisibleToAllUsers", api.setVisibleToAllUsers)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getStudioSessionMapping(request: GetStudioSessionMappingRequest): IO[
      AwsError,
      zio.aws.emr.model.GetStudioSessionMappingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.emr.model.GetStudioSessionMappingRequest,
      GetStudioSessionMappingResponse
    ]("getStudioSessionMapping", api.getStudioSessionMapping)(
      request.buildAwsValue()
    ).map(zio.aws.emr.model.GetStudioSessionMappingResponse.wrap)
      .provideEnvironment(r)
    def listSecurityConfigurations(
        request: ListSecurityConfigurationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.emr.model.SecurityConfigurationSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsRequest,
      SecurityConfigurationSummary,
      ListSecurityConfigurationsPublisher
    ](
      "listSecurityConfigurations",
      api.listSecurityConfigurationsPaginator,
      _.securityConfigurations()
    )(request.buildAwsValue())
      .map(item => zio.aws.emr.model.SecurityConfigurationSummary.wrap(item))
      .provideEnvironment(r)
    def listSecurityConfigurationsPaginated(
        request: ListSecurityConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.emr.model.ListSecurityConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsRequest,
      ListSecurityConfigurationsResponse
    ]("listSecurityConfigurations", api.listSecurityConfigurations)(
      request.buildAwsValue()
    ).map(zio.aws.emr.model.ListSecurityConfigurationsResponse.wrap)
      .provideEnvironment(r)
    def deleteStudioSessionMapping(
        request: DeleteStudioSessionMappingRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.emr.model.DeleteStudioSessionMappingRequest,
      DeleteStudioSessionMappingResponse
    ]("deleteStudioSessionMapping", api.deleteStudioSessionMapping)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putAutoTerminationPolicy(request: PutAutoTerminationPolicyRequest): IO[
      AwsError,
      zio.aws.emr.model.PutAutoTerminationPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.emr.model.PutAutoTerminationPolicyRequest,
      PutAutoTerminationPolicyResponse
    ]("putAutoTerminationPolicy", api.putAutoTerminationPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.emr.model.PutAutoTerminationPolicyResponse.wrap)
      .provideEnvironment(r)
    def modifyInstanceFleet(
        request: ModifyInstanceFleetRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.emr.model.ModifyInstanceFleetRequest,
      ModifyInstanceFleetResponse
    ]("modifyInstanceFleet", api.modifyInstanceFleet)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def removeTags(
        request: RemoveTagsRequest
    ): IO[AwsError, zio.aws.emr.model.RemoveTagsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.emr.model.RemoveTagsRequest,
        RemoveTagsResponse
      ]("removeTags", api.removeTags)(request.buildAwsValue())
        .map(zio.aws.emr.model.RemoveTagsResponse.wrap)
        .provideEnvironment(r)
    def listInstanceGroups(
        request: ListInstanceGroupsRequest
    ): ZStream[Any, AwsError, zio.aws.emr.model.InstanceGroup.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.emr.model.ListInstanceGroupsRequest,
        InstanceGroup,
        ListInstanceGroupsPublisher
      ](
        "listInstanceGroups",
        api.listInstanceGroupsPaginator,
        _.instanceGroups()
      )(request.buildAwsValue())
        .map(item => zio.aws.emr.model.InstanceGroup.wrap(item))
        .provideEnvironment(r)
    def listInstanceGroupsPaginated(
        request: ListInstanceGroupsRequest
    ): IO[AwsError, zio.aws.emr.model.ListInstanceGroupsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.emr.model.ListInstanceGroupsRequest,
        ListInstanceGroupsResponse
      ]("listInstanceGroups", api.listInstanceGroups)(request.buildAwsValue())
        .map(zio.aws.emr.model.ListInstanceGroupsResponse.wrap)
        .provideEnvironment(r)
    def getAutoTerminationPolicy(request: GetAutoTerminationPolicyRequest): IO[
      AwsError,
      zio.aws.emr.model.GetAutoTerminationPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.emr.model.GetAutoTerminationPolicyRequest,
      GetAutoTerminationPolicyResponse
    ]("getAutoTerminationPolicy", api.getAutoTerminationPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.emr.model.GetAutoTerminationPolicyResponse.wrap)
      .provideEnvironment(r)
    def updateStudioSessionMapping(
        request: UpdateStudioSessionMappingRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.emr.model.UpdateStudioSessionMappingRequest,
      UpdateStudioSessionMappingResponse
    ]("updateStudioSessionMapping", api.updateStudioSessionMapping)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putBlockPublicAccessConfiguration(
        request: PutBlockPublicAccessConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.emr.model.PutBlockPublicAccessConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.emr.model.PutBlockPublicAccessConfigurationRequest,
      PutBlockPublicAccessConfigurationResponse
    ](
      "putBlockPublicAccessConfiguration",
      api.putBlockPublicAccessConfiguration
    )(request.buildAwsValue())
      .map(zio.aws.emr.model.PutBlockPublicAccessConfigurationResponse.wrap)
      .provideEnvironment(r)
    def updateStudio(request: UpdateStudioRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.emr.model.UpdateStudioRequest,
        UpdateStudioResponse
      ]("updateStudio", api.updateStudio)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def putManagedScalingPolicy(
        request: PutManagedScalingPolicyRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.emr.model.PutManagedScalingPolicyRequest,
      PutManagedScalingPolicyResponse
    ]("putManagedScalingPolicy", api.putManagedScalingPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.emr.model.PutManagedScalingPolicyResponse.wrap)
      .provideEnvironment(r)
    def listSteps(
        request: ListStepsRequest
    ): ZStream[Any, AwsError, zio.aws.emr.model.StepSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.emr.model.ListStepsRequest,
        StepSummary,
        ListStepsPublisher
      ]("listSteps", api.listStepsPaginator, _.steps())(request.buildAwsValue())
        .map(item => zio.aws.emr.model.StepSummary.wrap(item))
        .provideEnvironment(r)
    def listStepsPaginated(
        request: ListStepsRequest
    ): IO[AwsError, zio.aws.emr.model.ListStepsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.emr.model.ListStepsRequest,
        ListStepsResponse
      ]("listSteps", api.listSteps)(request.buildAwsValue())
        .map(zio.aws.emr.model.ListStepsResponse.wrap)
        .provideEnvironment(r)
    def listStudios(
        request: ListStudiosRequest
    ): ZStream[Any, AwsError, zio.aws.emr.model.StudioSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.emr.model.ListStudiosRequest,
        StudioSummary,
        ListStudiosPublisher
      ]("listStudios", api.listStudiosPaginator, _.studios())(
        request.buildAwsValue()
      ).map(item => zio.aws.emr.model.StudioSummary.wrap(item))
        .provideEnvironment(r)
    def listStudiosPaginated(
        request: ListStudiosRequest
    ): IO[AwsError, zio.aws.emr.model.ListStudiosResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.emr.model.ListStudiosRequest,
        ListStudiosResponse
      ]("listStudios", api.listStudios)(request.buildAwsValue())
        .map(zio.aws.emr.model.ListStudiosResponse.wrap)
        .provideEnvironment(r)
    def addJobFlowSteps(
        request: AddJobFlowStepsRequest
    ): IO[AwsError, zio.aws.emr.model.AddJobFlowStepsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.emr.model.AddJobFlowStepsRequest,
        AddJobFlowStepsResponse
      ]("addJobFlowSteps", api.addJobFlowSteps)(request.buildAwsValue())
        .map(zio.aws.emr.model.AddJobFlowStepsResponse.wrap)
        .provideEnvironment(r)
    def createSecurityConfiguration(
        request: CreateSecurityConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.emr.model.CreateSecurityConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.emr.model.CreateSecurityConfigurationRequest,
      CreateSecurityConfigurationResponse
    ]("createSecurityConfiguration", api.createSecurityConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.emr.model.CreateSecurityConfigurationResponse.wrap)
      .provideEnvironment(r)
    def addInstanceFleet(
        request: AddInstanceFleetRequest
    ): IO[AwsError, zio.aws.emr.model.AddInstanceFleetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.emr.model.AddInstanceFleetRequest,
        AddInstanceFleetResponse
      ]("addInstanceFleet", api.addInstanceFleet)(request.buildAwsValue())
        .map(zio.aws.emr.model.AddInstanceFleetResponse.wrap)
        .provideEnvironment(r)
    def modifyCluster(
        request: ModifyClusterRequest
    ): IO[AwsError, zio.aws.emr.model.ModifyClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.emr.model.ModifyClusterRequest,
        ModifyClusterResponse
      ]("modifyCluster", api.modifyCluster)(request.buildAwsValue())
        .map(zio.aws.emr.model.ModifyClusterResponse.wrap)
        .provideEnvironment(r)
    def deleteSecurityConfiguration(
        request: DeleteSecurityConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.emr.model.DeleteSecurityConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.emr.model.DeleteSecurityConfigurationRequest,
      DeleteSecurityConfigurationResponse
    ]("deleteSecurityConfiguration", api.deleteSecurityConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.emr.model.DeleteSecurityConfigurationResponse.wrap)
      .provideEnvironment(r)
    def createStudioSessionMapping(
        request: CreateStudioSessionMappingRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.emr.model.CreateStudioSessionMappingRequest,
      CreateStudioSessionMappingResponse
    ]("createStudioSessionMapping", api.createStudioSessionMapping)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeSecurityConfiguration(
        request: DescribeSecurityConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.emr.model.DescribeSecurityConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.emr.model.DescribeSecurityConfigurationRequest,
      DescribeSecurityConfigurationResponse
    ]("describeSecurityConfiguration", api.describeSecurityConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.emr.model.DescribeSecurityConfigurationResponse.wrap)
      .provideEnvironment(r)
    def describeCluster(
        request: DescribeClusterRequest
    ): IO[AwsError, zio.aws.emr.model.DescribeClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.emr.model.DescribeClusterRequest,
        DescribeClusterResponse
      ]("describeCluster", api.describeCluster)(request.buildAwsValue())
        .map(zio.aws.emr.model.DescribeClusterResponse.wrap)
        .provideEnvironment(r)
    def listClusters(
        request: ListClustersRequest
    ): ZStream[Any, AwsError, zio.aws.emr.model.ClusterSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.emr.model.ListClustersRequest,
        ClusterSummary,
        ListClustersPublisher
      ]("listClusters", api.listClustersPaginator, _.clusters())(
        request.buildAwsValue()
      ).map(item => zio.aws.emr.model.ClusterSummary.wrap(item))
        .provideEnvironment(r)
    def listClustersPaginated(
        request: ListClustersRequest
    ): IO[AwsError, zio.aws.emr.model.ListClustersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.emr.model.ListClustersRequest,
        ListClustersResponse
      ]("listClusters", api.listClusters)(request.buildAwsValue())
        .map(zio.aws.emr.model.ListClustersResponse.wrap)
        .provideEnvironment(r)
    def addInstanceGroups(
        request: AddInstanceGroupsRequest
    ): IO[AwsError, zio.aws.emr.model.AddInstanceGroupsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.emr.model.AddInstanceGroupsRequest,
        AddInstanceGroupsResponse
      ]("addInstanceGroups", api.addInstanceGroups)(request.buildAwsValue())
        .map(zio.aws.emr.model.AddInstanceGroupsResponse.wrap)
        .provideEnvironment(r)
    def deleteStudio(request: DeleteStudioRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.emr.model.DeleteStudioRequest,
        DeleteStudioResponse
      ]("deleteStudio", api.deleteStudio)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def runJobFlow(
        request: RunJobFlowRequest
    ): IO[AwsError, zio.aws.emr.model.RunJobFlowResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.emr.model.RunJobFlowRequest,
        RunJobFlowResponse
      ]("runJobFlow", api.runJobFlow)(request.buildAwsValue())
        .map(zio.aws.emr.model.RunJobFlowResponse.wrap)
        .provideEnvironment(r)
    def removeAutoTerminationPolicy(
        request: RemoveAutoTerminationPolicyRequest
    ): IO[
      AwsError,
      zio.aws.emr.model.RemoveAutoTerminationPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.emr.model.RemoveAutoTerminationPolicyRequest,
      RemoveAutoTerminationPolicyResponse
    ]("removeAutoTerminationPolicy", api.removeAutoTerminationPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.emr.model.RemoveAutoTerminationPolicyResponse.wrap)
      .provideEnvironment(r)
    def describeReleaseLabel(
        request: DescribeReleaseLabelRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.emr.model.DescribeReleaseLabelResponse.ReadOnly,
      zio.aws.emr.model.SimplifiedApplication.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.emr.model.DescribeReleaseLabelRequest,
      DescribeReleaseLabelResponse,
      SimplifiedApplication
    ](
      "describeReleaseLabel",
      api.describeReleaseLabel,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.applications().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.emr.model.DescribeReleaseLabelResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.emr.model.SimplifiedApplication.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def describeReleaseLabelPaginated(
        request: DescribeReleaseLabelRequest
    ): IO[AwsError, zio.aws.emr.model.DescribeReleaseLabelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.emr.model.DescribeReleaseLabelRequest,
        DescribeReleaseLabelResponse
      ]("describeReleaseLabel", api.describeReleaseLabel)(
        request.buildAwsValue()
      ).map(zio.aws.emr.model.DescribeReleaseLabelResponse.wrap)
        .provideEnvironment(r)
    def startNotebookExecution(
        request: StartNotebookExecutionRequest
    ): IO[AwsError, zio.aws.emr.model.StartNotebookExecutionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.emr.model.StartNotebookExecutionRequest,
        StartNotebookExecutionResponse
      ]("startNotebookExecution", api.startNotebookExecution)(
        request.buildAwsValue()
      ).map(zio.aws.emr.model.StartNotebookExecutionResponse.wrap)
        .provideEnvironment(r)
    def removeManagedScalingPolicy(
        request: RemoveManagedScalingPolicyRequest
    ): IO[
      AwsError,
      zio.aws.emr.model.RemoveManagedScalingPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.emr.model.RemoveManagedScalingPolicyRequest,
      RemoveManagedScalingPolicyResponse
    ]("removeManagedScalingPolicy", api.removeManagedScalingPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.emr.model.RemoveManagedScalingPolicyResponse.wrap)
      .provideEnvironment(r)
    def modifyInstanceGroups(
        request: ModifyInstanceGroupsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.emr.model.ModifyInstanceGroupsRequest,
      ModifyInstanceGroupsResponse
    ]("modifyInstanceGroups", api.modifyInstanceGroups)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listNotebookExecutions(request: ListNotebookExecutionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.emr.model.NotebookExecutionSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.emr.model.ListNotebookExecutionsRequest,
      NotebookExecutionSummary,
      ListNotebookExecutionsPublisher
    ](
      "listNotebookExecutions",
      api.listNotebookExecutionsPaginator,
      _.notebookExecutions()
    )(request.buildAwsValue())
      .map(item => zio.aws.emr.model.NotebookExecutionSummary.wrap(item))
      .provideEnvironment(r)
    def listNotebookExecutionsPaginated(
        request: ListNotebookExecutionsRequest
    ): IO[AwsError, zio.aws.emr.model.ListNotebookExecutionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.emr.model.ListNotebookExecutionsRequest,
        ListNotebookExecutionsResponse
      ]("listNotebookExecutions", api.listNotebookExecutions)(
        request.buildAwsValue()
      ).map(zio.aws.emr.model.ListNotebookExecutionsResponse.wrap)
        .provideEnvironment(r)
    def terminateJobFlows(
        request: TerminateJobFlowsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.emr.model.TerminateJobFlowsRequest,
      TerminateJobFlowsResponse
    ]("terminateJobFlows", api.terminateJobFlows)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def listInstanceFleets(
        request: ListInstanceFleetsRequest
    ): ZStream[Any, AwsError, zio.aws.emr.model.InstanceFleet.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.emr.model.ListInstanceFleetsRequest,
        InstanceFleet,
        ListInstanceFleetsPublisher
      ](
        "listInstanceFleets",
        api.listInstanceFleetsPaginator,
        _.instanceFleets()
      )(request.buildAwsValue())
        .map(item => zio.aws.emr.model.InstanceFleet.wrap(item))
        .provideEnvironment(r)
    def listInstanceFleetsPaginated(
        request: ListInstanceFleetsRequest
    ): IO[AwsError, zio.aws.emr.model.ListInstanceFleetsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.emr.model.ListInstanceFleetsRequest,
        ListInstanceFleetsResponse
      ]("listInstanceFleets", api.listInstanceFleets)(request.buildAwsValue())
        .map(zio.aws.emr.model.ListInstanceFleetsResponse.wrap)
        .provideEnvironment(r)
    def getManagedScalingPolicy(request: GetManagedScalingPolicyRequest): IO[
      AwsError,
      zio.aws.emr.model.GetManagedScalingPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.emr.model.GetManagedScalingPolicyRequest,
      GetManagedScalingPolicyResponse
    ]("getManagedScalingPolicy", api.getManagedScalingPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.emr.model.GetManagedScalingPolicyResponse.wrap)
      .provideEnvironment(r)
  }
  def getBlockPublicAccessConfiguration(
      request: GetBlockPublicAccessConfigurationRequest
  ): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.GetBlockPublicAccessConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBlockPublicAccessConfiguration(request))
  def listStudioSessionMappings(
      request: ListStudioSessionMappingsRequest
  ): ZStream[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.SessionMappingSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listStudioSessionMappings(request))
  def listStudioSessionMappingsPaginated(
      request: ListStudioSessionMappingsRequest
  ): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.ListStudioSessionMappingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStudioSessionMappingsPaginated(request))
  def createStudio(request: CreateStudioRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.CreateStudioResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createStudio(request))
  def describeNotebookExecution(request: DescribeNotebookExecutionRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.DescribeNotebookExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeNotebookExecution(request))
  def stopNotebookExecution(
      request: StopNotebookExecutionRequest
  ): ZIO[zio.aws.emr.Emr, AwsError, Unit] =
    ZIO.serviceWithZIO(_.stopNotebookExecution(request))
  def listBootstrapActions(
      request: ListBootstrapActionsRequest
  ): ZStream[zio.aws.emr.Emr, AwsError, zio.aws.emr.model.Command.ReadOnly] =
    ZStream.serviceWithStream(_.listBootstrapActions(request))
  def listBootstrapActionsPaginated(request: ListBootstrapActionsRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.ListBootstrapActionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBootstrapActionsPaginated(request))
  def listReleaseLabels(
      request: ListReleaseLabelsRequest
  ): ZStream[zio.aws.emr.Emr, AwsError, String] =
    ZStream.serviceWithStream(_.listReleaseLabels(request))
  def listReleaseLabelsPaginated(request: ListReleaseLabelsRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.ListReleaseLabelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listReleaseLabelsPaginated(request))
  def setTerminationProtection(
      request: SetTerminationProtectionRequest
  ): ZIO[zio.aws.emr.Emr, AwsError, Unit] =
    ZIO.serviceWithZIO(_.setTerminationProtection(request))
  def describeStep(request: DescribeStepRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.DescribeStepResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStep(request))
  def cancelSteps(request: CancelStepsRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.CancelStepsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelSteps(request))
  def listInstances(
      request: ListInstancesRequest
  ): ZStream[zio.aws.emr.Emr, AwsError, zio.aws.emr.model.Instance.ReadOnly] =
    ZStream.serviceWithStream(_.listInstances(request))
  def listInstancesPaginated(request: ListInstancesRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.ListInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInstancesPaginated(request))
  def describeStudio(request: DescribeStudioRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.DescribeStudioResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStudio(request))
  def addTags(request: AddTagsRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.AddTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addTags(request))
  def putAutoScalingPolicy(request: PutAutoScalingPolicyRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.PutAutoScalingPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putAutoScalingPolicy(request))
  def removeAutoScalingPolicy(request: RemoveAutoScalingPolicyRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.RemoveAutoScalingPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeAutoScalingPolicy(request))
  def setVisibleToAllUsers(
      request: SetVisibleToAllUsersRequest
  ): ZIO[zio.aws.emr.Emr, AwsError, Unit] =
    ZIO.serviceWithZIO(_.setVisibleToAllUsers(request))
  def getStudioSessionMapping(request: GetStudioSessionMappingRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.GetStudioSessionMappingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStudioSessionMapping(request))
  def listSecurityConfigurations(
      request: ListSecurityConfigurationsRequest
  ): ZStream[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.SecurityConfigurationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSecurityConfigurations(request))
  def listSecurityConfigurationsPaginated(
      request: ListSecurityConfigurationsRequest
  ): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.ListSecurityConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSecurityConfigurationsPaginated(request))
  def deleteStudioSessionMapping(
      request: DeleteStudioSessionMappingRequest
  ): ZIO[zio.aws.emr.Emr, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteStudioSessionMapping(request))
  def putAutoTerminationPolicy(request: PutAutoTerminationPolicyRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.PutAutoTerminationPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putAutoTerminationPolicy(request))
  def modifyInstanceFleet(
      request: ModifyInstanceFleetRequest
  ): ZIO[zio.aws.emr.Emr, AwsError, Unit] =
    ZIO.serviceWithZIO(_.modifyInstanceFleet(request))
  def removeTags(request: RemoveTagsRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.RemoveTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeTags(request))
  def listInstanceGroups(request: ListInstanceGroupsRequest): ZStream[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.InstanceGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.listInstanceGroups(request))
  def listInstanceGroupsPaginated(request: ListInstanceGroupsRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.ListInstanceGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInstanceGroupsPaginated(request))
  def getAutoTerminationPolicy(request: GetAutoTerminationPolicyRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.GetAutoTerminationPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAutoTerminationPolicy(request))
  def updateStudioSessionMapping(
      request: UpdateStudioSessionMappingRequest
  ): ZIO[zio.aws.emr.Emr, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateStudioSessionMapping(request))
  def putBlockPublicAccessConfiguration(
      request: PutBlockPublicAccessConfigurationRequest
  ): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.PutBlockPublicAccessConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putBlockPublicAccessConfiguration(request))
  def updateStudio(
      request: UpdateStudioRequest
  ): ZIO[zio.aws.emr.Emr, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateStudio(request))
  def putManagedScalingPolicy(
      request: PutManagedScalingPolicyRequest
  ): ZIO[zio.aws.emr.Emr, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.putManagedScalingPolicy(request))
  def listSteps(request: ListStepsRequest): ZStream[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.StepSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSteps(request))
  def listStepsPaginated(request: ListStepsRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.ListStepsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStepsPaginated(request))
  def listStudios(request: ListStudiosRequest): ZStream[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.StudioSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listStudios(request))
  def listStudiosPaginated(request: ListStudiosRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.ListStudiosResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStudiosPaginated(request))
  def addJobFlowSteps(request: AddJobFlowStepsRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.AddJobFlowStepsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addJobFlowSteps(request))
  def createSecurityConfiguration(
      request: CreateSecurityConfigurationRequest
  ): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.CreateSecurityConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSecurityConfiguration(request))
  def addInstanceFleet(request: AddInstanceFleetRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.AddInstanceFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addInstanceFleet(request))
  def modifyCluster(request: ModifyClusterRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.ModifyClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyCluster(request))
  def deleteSecurityConfiguration(
      request: DeleteSecurityConfigurationRequest
  ): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.DeleteSecurityConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSecurityConfiguration(request))
  def createStudioSessionMapping(
      request: CreateStudioSessionMappingRequest
  ): ZIO[zio.aws.emr.Emr, AwsError, Unit] =
    ZIO.serviceWithZIO(_.createStudioSessionMapping(request))
  def describeSecurityConfiguration(
      request: DescribeSecurityConfigurationRequest
  ): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.DescribeSecurityConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSecurityConfiguration(request))
  def describeCluster(request: DescribeClusterRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.DescribeClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCluster(request))
  def listClusters(request: ListClustersRequest): ZStream[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.ClusterSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listClusters(request))
  def listClustersPaginated(request: ListClustersRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.ListClustersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listClustersPaginated(request))
  def addInstanceGroups(request: AddInstanceGroupsRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.AddInstanceGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addInstanceGroups(request))
  def deleteStudio(
      request: DeleteStudioRequest
  ): ZIO[zio.aws.emr.Emr, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteStudio(request))
  def runJobFlow(request: RunJobFlowRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.RunJobFlowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.runJobFlow(request))
  def removeAutoTerminationPolicy(
      request: RemoveAutoTerminationPolicyRequest
  ): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.RemoveAutoTerminationPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeAutoTerminationPolicy(request))
  def describeReleaseLabel(
      request: DescribeReleaseLabelRequest
  ): ZIO[zio.aws.emr.Emr, AwsError, StreamingOutputResult[
    Any,
    zio.aws.emr.model.DescribeReleaseLabelResponse.ReadOnly,
    zio.aws.emr.model.SimplifiedApplication.ReadOnly
  ]] = ZIO.serviceWithZIO(_.describeReleaseLabel(request))
  def describeReleaseLabelPaginated(request: DescribeReleaseLabelRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.DescribeReleaseLabelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReleaseLabelPaginated(request))
  def startNotebookExecution(request: StartNotebookExecutionRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.StartNotebookExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startNotebookExecution(request))
  def removeManagedScalingPolicy(
      request: RemoveManagedScalingPolicyRequest
  ): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.RemoveManagedScalingPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeManagedScalingPolicy(request))
  def modifyInstanceGroups(
      request: ModifyInstanceGroupsRequest
  ): ZIO[zio.aws.emr.Emr, AwsError, Unit] =
    ZIO.serviceWithZIO(_.modifyInstanceGroups(request))
  def listNotebookExecutions(request: ListNotebookExecutionsRequest): ZStream[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.NotebookExecutionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listNotebookExecutions(request))
  def listNotebookExecutionsPaginated(
      request: ListNotebookExecutionsRequest
  ): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.ListNotebookExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listNotebookExecutionsPaginated(request))
  def terminateJobFlows(
      request: TerminateJobFlowsRequest
  ): ZIO[zio.aws.emr.Emr, AwsError, Unit] =
    ZIO.serviceWithZIO(_.terminateJobFlows(request))
  def listInstanceFleets(request: ListInstanceFleetsRequest): ZStream[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.InstanceFleet.ReadOnly
  ] = ZStream.serviceWithStream(_.listInstanceFleets(request))
  def listInstanceFleetsPaginated(request: ListInstanceFleetsRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.ListInstanceFleetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInstanceFleetsPaginated(request))
  def getManagedScalingPolicy(request: GetManagedScalingPolicyRequest): ZIO[
    zio.aws.emr.Emr,
    AwsError,
    zio.aws.emr.model.GetManagedScalingPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getManagedScalingPolicy(request))
}
