package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlStringMaxLen256
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartNotebookExecutionResponse(
    notebookExecutionId: Option[XmlStringMaxLen256] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.StartNotebookExecutionResponse = {
    import StartNotebookExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.StartNotebookExecutionResponse
      .builder()
      .optionallyWith(
        notebookExecutionId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.notebookExecutionId)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.StartNotebookExecutionResponse.ReadOnly =
    zio.aws.emr.model.StartNotebookExecutionResponse.wrap(buildAwsValue())
}
object StartNotebookExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.StartNotebookExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.StartNotebookExecutionResponse =
      zio.aws.emr.model
        .StartNotebookExecutionResponse(notebookExecutionId.map(value => value))
    def notebookExecutionId: Option[XmlStringMaxLen256]
    def getNotebookExecutionId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("notebookExecutionId", notebookExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.StartNotebookExecutionResponse
  ) extends zio.aws.emr.model.StartNotebookExecutionResponse.ReadOnly {
    override val notebookExecutionId: Option[XmlStringMaxLen256] = scala
      .Option(impl.notebookExecutionId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.StartNotebookExecutionResponse
  ): zio.aws.emr.model.StartNotebookExecutionResponse.ReadOnly = new Wrapper(
    impl
  )
}
