package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait RepoUpgradeOnBoot {
  def unwrap: software.amazon.awssdk.services.emr.model.RepoUpgradeOnBoot
}
object RepoUpgradeOnBoot {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.RepoUpgradeOnBoot
  ): zio.aws.emr.model.RepoUpgradeOnBoot = value match {
    case software.amazon.awssdk.services.emr.model.RepoUpgradeOnBoot.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.RepoUpgradeOnBoot.SECURITY =>
      val r = SECURITY
      r
    case software.amazon.awssdk.services.emr.model.RepoUpgradeOnBoot.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion extends zio.aws.emr.model.RepoUpgradeOnBoot {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.RepoUpgradeOnBoot =
      software.amazon.awssdk.services.emr.model.RepoUpgradeOnBoot.UNKNOWN_TO_SDK_VERSION
  }
  case object SECURITY extends zio.aws.emr.model.RepoUpgradeOnBoot {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.RepoUpgradeOnBoot =
      software.amazon.awssdk.services.emr.model.RepoUpgradeOnBoot.SECURITY
  }
  case object NONE extends zio.aws.emr.model.RepoUpgradeOnBoot {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.RepoUpgradeOnBoot =
      software.amazon.awssdk.services.emr.model.RepoUpgradeOnBoot.NONE
  }
}
