package zio.aws.emr.model
import zio.aws.emr.model.primitives.Marker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListStudioSessionMappingsResponse(
    sessionMappings: Option[Iterable[zio.aws.emr.model.SessionMappingSummary]] =
      None,
    marker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsResponse = {
    import ListStudioSessionMappingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsResponse
      .builder()
      .optionallyWith(
        sessionMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sessionMappings)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ListStudioSessionMappingsResponse.ReadOnly =
    zio.aws.emr.model.ListStudioSessionMappingsResponse.wrap(buildAwsValue())
}
object ListStudioSessionMappingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListStudioSessionMappingsResponse =
      zio.aws.emr.model.ListStudioSessionMappingsResponse(
        sessionMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def sessionMappings
        : Option[List[zio.aws.emr.model.SessionMappingSummary.ReadOnly]]
    def marker: Option[Marker]
    def getSessionMappings: ZIO[Any, AwsError, List[
      zio.aws.emr.model.SessionMappingSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("sessionMappings", sessionMappings)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsResponse
  ) extends zio.aws.emr.model.ListStudioSessionMappingsResponse.ReadOnly {
    override val sessionMappings
        : Option[List[zio.aws.emr.model.SessionMappingSummary.ReadOnly]] = scala
      .Option(impl.sessionMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.SessionMappingSummary.wrap(item)
        }.toList
      )
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.emr.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsResponse
  ): zio.aws.emr.model.ListStudioSessionMappingsResponse.ReadOnly = new Wrapper(
    impl
  )
}
