package zio.aws.emr.model
import zio.aws.emr.model.primitives.Marker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListClustersResponse(
    clusters: Option[Iterable[zio.aws.emr.model.ClusterSummary]] = None,
    marker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListClustersResponse = {
    import ListClustersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListClustersResponse
      .builder()
      .optionallyWith(
        clusters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusters)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ListClustersResponse.ReadOnly =
    zio.aws.emr.model.ListClustersResponse.wrap(buildAwsValue())
}
object ListClustersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListClustersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListClustersResponse =
      zio.aws.emr.model.ListClustersResponse(
        clusters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def clusters: Option[List[zio.aws.emr.model.ClusterSummary.ReadOnly]]
    def marker: Option[Marker]
    def getClusters
        : ZIO[Any, AwsError, List[zio.aws.emr.model.ClusterSummary.ReadOnly]] =
      AwsError.unwrapOptionField("clusters", clusters)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListClustersResponse
  ) extends zio.aws.emr.model.ListClustersResponse.ReadOnly {
    override val clusters
        : Option[List[zio.aws.emr.model.ClusterSummary.ReadOnly]] = scala
      .Option(impl.clusters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.ClusterSummary.wrap(item)
        }.toList
      )
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.emr.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListClustersResponse
  ): zio.aws.emr.model.ListClustersResponse.ReadOnly = new Wrapper(impl)
}
