package zio.aws.emr.model
import zio.aws.emr.model.primitives.{XmlStringMaxLen256, Integer, InstanceType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class JobFlowInstancesConfig(
    masterInstanceType: Option[InstanceType] = None,
    slaveInstanceType: Option[InstanceType] = None,
    instanceCount: Option[Integer] = None,
    instanceGroups: Option[Iterable[zio.aws.emr.model.InstanceGroupConfig]] =
      None,
    instanceFleets: Option[Iterable[zio.aws.emr.model.InstanceFleetConfig]] =
      None,
    ec2KeyName: Option[XmlStringMaxLen256] = None,
    placement: Option[zio.aws.emr.model.PlacementType] = None,
    keepJobFlowAliveWhenNoSteps: Option[Boolean] = None,
    terminationProtected: Option[Boolean] = None,
    hadoopVersion: Option[XmlStringMaxLen256] = None,
    ec2SubnetId: Option[XmlStringMaxLen256] = None,
    ec2SubnetIds: Option[Iterable[XmlStringMaxLen256]] = None,
    emrManagedMasterSecurityGroup: Option[XmlStringMaxLen256] = None,
    emrManagedSlaveSecurityGroup: Option[XmlStringMaxLen256] = None,
    serviceAccessSecurityGroup: Option[XmlStringMaxLen256] = None,
    additionalMasterSecurityGroups: Option[Iterable[XmlStringMaxLen256]] = None,
    additionalSlaveSecurityGroups: Option[Iterable[XmlStringMaxLen256]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.JobFlowInstancesConfig = {
    import JobFlowInstancesConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.JobFlowInstancesConfig
      .builder()
      .optionallyWith(
        masterInstanceType.map(value =>
          InstanceType.unwrap(value): java.lang.String
        )
      )(_.masterInstanceType)
      .optionallyWith(
        slaveInstanceType.map(value =>
          InstanceType.unwrap(value): java.lang.String
        )
      )(_.slaveInstanceType)
      .optionallyWith(instanceCount.map(value => value: java.lang.Integer))(
        _.instanceCount
      )
      .optionallyWith(
        instanceGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceGroups)
      .optionallyWith(
        instanceFleets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceFleets)
      .optionallyWith(
        ec2KeyName.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.ec2KeyName)
      .optionallyWith(placement.map(value => value.buildAwsValue()))(
        _.placement
      )
      .optionallyWith(
        keepJobFlowAliveWhenNoSteps.map(value => value: java.lang.Boolean)
      )(_.keepJobFlowAliveWhenNoSteps)
      .optionallyWith(
        terminationProtected.map(value => value: java.lang.Boolean)
      )(_.terminationProtected)
      .optionallyWith(
        hadoopVersion.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.hadoopVersion)
      .optionallyWith(
        ec2SubnetId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.ec2SubnetId)
      .optionallyWith(
        ec2SubnetIds.map(value =>
          value.map { item =>
            XmlStringMaxLen256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ec2SubnetIds)
      .optionallyWith(
        emrManagedMasterSecurityGroup.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.emrManagedMasterSecurityGroup)
      .optionallyWith(
        emrManagedSlaveSecurityGroup.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.emrManagedSlaveSecurityGroup)
      .optionallyWith(
        serviceAccessSecurityGroup.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.serviceAccessSecurityGroup)
      .optionallyWith(
        additionalMasterSecurityGroups.map(value =>
          value.map { item =>
            XmlStringMaxLen256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.additionalMasterSecurityGroups)
      .optionallyWith(
        additionalSlaveSecurityGroups.map(value =>
          value.map { item =>
            XmlStringMaxLen256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.additionalSlaveSecurityGroups)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.JobFlowInstancesConfig.ReadOnly =
    zio.aws.emr.model.JobFlowInstancesConfig.wrap(buildAwsValue())
}
object JobFlowInstancesConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.JobFlowInstancesConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.JobFlowInstancesConfig =
      zio.aws.emr.model.JobFlowInstancesConfig(
        masterInstanceType.map(value => value),
        slaveInstanceType.map(value => value),
        instanceCount.map(value => value),
        instanceGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceFleets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ec2KeyName.map(value => value),
        placement.map(value => value.asEditable),
        keepJobFlowAliveWhenNoSteps.map(value => value),
        terminationProtected.map(value => value),
        hadoopVersion.map(value => value),
        ec2SubnetId.map(value => value),
        ec2SubnetIds.map(value => value),
        emrManagedMasterSecurityGroup.map(value => value),
        emrManagedSlaveSecurityGroup.map(value => value),
        serviceAccessSecurityGroup.map(value => value),
        additionalMasterSecurityGroups.map(value => value),
        additionalSlaveSecurityGroups.map(value => value)
      )
    def masterInstanceType: Option[InstanceType]
    def slaveInstanceType: Option[InstanceType]
    def instanceCount: Option[Integer]
    def instanceGroups
        : Option[List[zio.aws.emr.model.InstanceGroupConfig.ReadOnly]]
    def instanceFleets
        : Option[List[zio.aws.emr.model.InstanceFleetConfig.ReadOnly]]
    def ec2KeyName: Option[XmlStringMaxLen256]
    def placement: Option[zio.aws.emr.model.PlacementType.ReadOnly]
    def keepJobFlowAliveWhenNoSteps: Option[Boolean]
    def terminationProtected: Option[Boolean]
    def hadoopVersion: Option[XmlStringMaxLen256]
    def ec2SubnetId: Option[XmlStringMaxLen256]
    def ec2SubnetIds: Option[List[XmlStringMaxLen256]]
    def emrManagedMasterSecurityGroup: Option[XmlStringMaxLen256]
    def emrManagedSlaveSecurityGroup: Option[XmlStringMaxLen256]
    def serviceAccessSecurityGroup: Option[XmlStringMaxLen256]
    def additionalMasterSecurityGroups: Option[List[XmlStringMaxLen256]]
    def additionalSlaveSecurityGroups: Option[List[XmlStringMaxLen256]]
    def getMasterInstanceType: ZIO[Any, AwsError, InstanceType] =
      AwsError.unwrapOptionField("masterInstanceType", masterInstanceType)
    def getSlaveInstanceType: ZIO[Any, AwsError, InstanceType] =
      AwsError.unwrapOptionField("slaveInstanceType", slaveInstanceType)
    def getInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getInstanceGroups: ZIO[Any, AwsError, List[
      zio.aws.emr.model.InstanceGroupConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceGroups", instanceGroups)
    def getInstanceFleets: ZIO[Any, AwsError, List[
      zio.aws.emr.model.InstanceFleetConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceFleets", instanceFleets)
    def getEc2KeyName: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("ec2KeyName", ec2KeyName)
    def getPlacement
        : ZIO[Any, AwsError, zio.aws.emr.model.PlacementType.ReadOnly] =
      AwsError.unwrapOptionField("placement", placement)
    def getKeepJobFlowAliveWhenNoSteps: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "keepJobFlowAliveWhenNoSteps",
        keepJobFlowAliveWhenNoSteps
      )
    def getTerminationProtected: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("terminationProtected", terminationProtected)
    def getHadoopVersion: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("hadoopVersion", hadoopVersion)
    def getEc2SubnetId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("ec2SubnetId", ec2SubnetId)
    def getEc2SubnetIds: ZIO[Any, AwsError, List[XmlStringMaxLen256]] =
      AwsError.unwrapOptionField("ec2SubnetIds", ec2SubnetIds)
    def getEmrManagedMasterSecurityGroup
        : ZIO[Any, AwsError, XmlStringMaxLen256] = AwsError.unwrapOptionField(
      "emrManagedMasterSecurityGroup",
      emrManagedMasterSecurityGroup
    )
    def getEmrManagedSlaveSecurityGroup
        : ZIO[Any, AwsError, XmlStringMaxLen256] = AwsError.unwrapOptionField(
      "emrManagedSlaveSecurityGroup",
      emrManagedSlaveSecurityGroup
    )
    def getServiceAccessSecurityGroup: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField(
        "serviceAccessSecurityGroup",
        serviceAccessSecurityGroup
      )
    def getAdditionalMasterSecurityGroups
        : ZIO[Any, AwsError, List[XmlStringMaxLen256]] =
      AwsError.unwrapOptionField(
        "additionalMasterSecurityGroups",
        additionalMasterSecurityGroups
      )
    def getAdditionalSlaveSecurityGroups
        : ZIO[Any, AwsError, List[XmlStringMaxLen256]] =
      AwsError.unwrapOptionField(
        "additionalSlaveSecurityGroups",
        additionalSlaveSecurityGroups
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.JobFlowInstancesConfig
  ) extends zio.aws.emr.model.JobFlowInstancesConfig.ReadOnly {
    override val masterInstanceType: Option[InstanceType] = scala
      .Option(impl.masterInstanceType())
      .map(value => zio.aws.emr.model.primitives.InstanceType(value))
    override val slaveInstanceType: Option[InstanceType] = scala
      .Option(impl.slaveInstanceType())
      .map(value => zio.aws.emr.model.primitives.InstanceType(value))
    override val instanceCount: Option[Integer] =
      scala.Option(impl.instanceCount()).map(value => value: Integer)
    override val instanceGroups
        : Option[List[zio.aws.emr.model.InstanceGroupConfig.ReadOnly]] = scala
      .Option(impl.instanceGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.InstanceGroupConfig.wrap(item)
        }.toList
      )
    override val instanceFleets
        : Option[List[zio.aws.emr.model.InstanceFleetConfig.ReadOnly]] = scala
      .Option(impl.instanceFleets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.InstanceFleetConfig.wrap(item)
        }.toList
      )
    override val ec2KeyName: Option[XmlStringMaxLen256] = scala
      .Option(impl.ec2KeyName())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val placement: Option[zio.aws.emr.model.PlacementType.ReadOnly] =
      scala
        .Option(impl.placement())
        .map(value => zio.aws.emr.model.PlacementType.wrap(value))
    override val keepJobFlowAliveWhenNoSteps: Option[Boolean] = scala
      .Option(impl.keepJobFlowAliveWhenNoSteps())
      .map(value => value: Boolean)
    override val terminationProtected: Option[Boolean] =
      scala.Option(impl.terminationProtected()).map(value => value: Boolean)
    override val hadoopVersion: Option[XmlStringMaxLen256] = scala
      .Option(impl.hadoopVersion())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val ec2SubnetId: Option[XmlStringMaxLen256] = scala
      .Option(impl.ec2SubnetId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val ec2SubnetIds: Option[List[XmlStringMaxLen256]] = scala
      .Option(impl.ec2SubnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.primitives.XmlStringMaxLen256(item)
        }.toList
      )
    override val emrManagedMasterSecurityGroup: Option[XmlStringMaxLen256] =
      scala
        .Option(impl.emrManagedMasterSecurityGroup())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val emrManagedSlaveSecurityGroup: Option[XmlStringMaxLen256] =
      scala
        .Option(impl.emrManagedSlaveSecurityGroup())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val serviceAccessSecurityGroup: Option[XmlStringMaxLen256] = scala
      .Option(impl.serviceAccessSecurityGroup())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val additionalMasterSecurityGroups
        : Option[List[XmlStringMaxLen256]] = scala
      .Option(impl.additionalMasterSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.primitives.XmlStringMaxLen256(item)
        }.toList
      )
    override val additionalSlaveSecurityGroups
        : Option[List[XmlStringMaxLen256]] = scala
      .Option(impl.additionalSlaveSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.primitives.XmlStringMaxLen256(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.JobFlowInstancesConfig
  ): zio.aws.emr.model.JobFlowInstancesConfig.ReadOnly = new Wrapper(impl)
}
