package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceGroupStateChangeReason(
    code: Option[zio.aws.emr.model.InstanceGroupStateChangeReasonCode] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.InstanceGroupStateChangeReason = {
    import InstanceGroupStateChangeReason.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.InstanceGroupStateChangeReason
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.InstanceGroupStateChangeReason.ReadOnly =
    zio.aws.emr.model.InstanceGroupStateChangeReason.wrap(buildAwsValue())
}
object InstanceGroupStateChangeReason {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.InstanceGroupStateChangeReason
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.InstanceGroupStateChangeReason =
      zio.aws.emr.model.InstanceGroupStateChangeReason(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Option[zio.aws.emr.model.InstanceGroupStateChangeReasonCode]
    def message: Option[String]
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.InstanceGroupStateChangeReasonCode
    ] = AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.InstanceGroupStateChangeReason
  ) extends zio.aws.emr.model.InstanceGroupStateChangeReason.ReadOnly {
    override val code
        : Option[zio.aws.emr.model.InstanceGroupStateChangeReasonCode] = scala
      .Option(impl.code())
      .map(value =>
        zio.aws.emr.model.InstanceGroupStateChangeReasonCode.wrap(value)
      )
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.InstanceGroupStateChangeReason
  ): zio.aws.emr.model.InstanceGroupStateChangeReason.ReadOnly = new Wrapper(
    impl
  )
}
