package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceFleetProvisioningSpecifications(
    spotSpecification: Option[zio.aws.emr.model.SpotProvisioningSpecification] =
      None,
    onDemandSpecification: Option[
      zio.aws.emr.model.OnDemandProvisioningSpecification
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.InstanceFleetProvisioningSpecifications = {
    import InstanceFleetProvisioningSpecifications.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.InstanceFleetProvisioningSpecifications
      .builder()
      .optionallyWith(spotSpecification.map(value => value.buildAwsValue()))(
        _.spotSpecification
      )
      .optionallyWith(
        onDemandSpecification.map(value => value.buildAwsValue())
      )(_.onDemandSpecification)
      .build()
  }
  def asReadOnly
      : zio.aws.emr.model.InstanceFleetProvisioningSpecifications.ReadOnly =
    zio.aws.emr.model.InstanceFleetProvisioningSpecifications
      .wrap(buildAwsValue())
}
object InstanceFleetProvisioningSpecifications {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.InstanceFleetProvisioningSpecifications
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.InstanceFleetProvisioningSpecifications =
      zio.aws.emr.model.InstanceFleetProvisioningSpecifications(
        spotSpecification.map(value => value.asEditable),
        onDemandSpecification.map(value => value.asEditable)
      )
    def spotSpecification
        : Option[zio.aws.emr.model.SpotProvisioningSpecification.ReadOnly]
    def onDemandSpecification
        : Option[zio.aws.emr.model.OnDemandProvisioningSpecification.ReadOnly]
    def getSpotSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.SpotProvisioningSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("spotSpecification", spotSpecification)
    def getOnDemandSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.OnDemandProvisioningSpecification.ReadOnly
    ] =
      AwsError.unwrapOptionField("onDemandSpecification", onDemandSpecification)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.InstanceFleetProvisioningSpecifications
  ) extends zio.aws.emr.model.InstanceFleetProvisioningSpecifications.ReadOnly {
    override val spotSpecification
        : Option[zio.aws.emr.model.SpotProvisioningSpecification.ReadOnly] =
      scala
        .Option(impl.spotSpecification())
        .map(value =>
          zio.aws.emr.model.SpotProvisioningSpecification.wrap(value)
        )
    override val onDemandSpecification
        : Option[zio.aws.emr.model.OnDemandProvisioningSpecification.ReadOnly] =
      scala
        .Option(impl.onDemandSpecification())
        .map(value =>
          zio.aws.emr.model.OnDemandProvisioningSpecification.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.InstanceFleetProvisioningSpecifications
  ): zio.aws.emr.model.InstanceFleetProvisioningSpecifications.ReadOnly =
    new Wrapper(impl)
}
