package zio.aws.emr.model
import java.lang.Integer
import zio.aws.emr.model.primitives.{WholeNumber, XmlStringMaxLen256}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceFleetConfig(
    name: Option[XmlStringMaxLen256] = None,
    instanceFleetType: zio.aws.emr.model.InstanceFleetType,
    targetOnDemandCapacity: Option[WholeNumber] = None,
    targetSpotCapacity: Option[WholeNumber] = None,
    instanceTypeConfigs: Option[
      Iterable[zio.aws.emr.model.InstanceTypeConfig]
    ] = None,
    launchSpecifications: Option[
      zio.aws.emr.model.InstanceFleetProvisioningSpecifications
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.InstanceFleetConfig = {
    import InstanceFleetConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.InstanceFleetConfig
      .builder()
      .optionallyWith(
        name.map(value => XmlStringMaxLen256.unwrap(value): java.lang.String)
      )(_.name)
      .instanceFleetType(instanceFleetType.unwrap)
      .optionallyWith(
        targetOnDemandCapacity.map(value => WholeNumber.unwrap(value): Integer)
      )(_.targetOnDemandCapacity)
      .optionallyWith(
        targetSpotCapacity.map(value => WholeNumber.unwrap(value): Integer)
      )(_.targetSpotCapacity)
      .optionallyWith(
        instanceTypeConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceTypeConfigs)
      .optionallyWith(launchSpecifications.map(value => value.buildAwsValue()))(
        _.launchSpecifications
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.InstanceFleetConfig.ReadOnly =
    zio.aws.emr.model.InstanceFleetConfig.wrap(buildAwsValue())
}
object InstanceFleetConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.InstanceFleetConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.InstanceFleetConfig =
      zio.aws.emr.model.InstanceFleetConfig(
        name.map(value => value),
        instanceFleetType,
        targetOnDemandCapacity.map(value => value),
        targetSpotCapacity.map(value => value),
        instanceTypeConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        launchSpecifications.map(value => value.asEditable)
      )
    def name: Option[XmlStringMaxLen256]
    def instanceFleetType: zio.aws.emr.model.InstanceFleetType
    def targetOnDemandCapacity: Option[WholeNumber]
    def targetSpotCapacity: Option[WholeNumber]
    def instanceTypeConfigs
        : Option[List[zio.aws.emr.model.InstanceTypeConfig.ReadOnly]]
    def launchSpecifications: Option[
      zio.aws.emr.model.InstanceFleetProvisioningSpecifications.ReadOnly
    ]
    def getName: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("name", name)
    def getInstanceFleetType
        : ZIO[Any, Nothing, zio.aws.emr.model.InstanceFleetType] =
      ZIO.succeed(instanceFleetType)
    def getTargetOnDemandCapacity: ZIO[Any, AwsError, WholeNumber] = AwsError
      .unwrapOptionField("targetOnDemandCapacity", targetOnDemandCapacity)
    def getTargetSpotCapacity: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("targetSpotCapacity", targetSpotCapacity)
    def getInstanceTypeConfigs: ZIO[Any, AwsError, List[
      zio.aws.emr.model.InstanceTypeConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceTypeConfigs", instanceTypeConfigs)
    def getLaunchSpecifications: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.InstanceFleetProvisioningSpecifications.ReadOnly
    ] = AwsError.unwrapOptionField("launchSpecifications", launchSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.InstanceFleetConfig
  ) extends zio.aws.emr.model.InstanceFleetConfig.ReadOnly {
    override val name: Option[XmlStringMaxLen256] = scala
      .Option(impl.name())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val instanceFleetType: zio.aws.emr.model.InstanceFleetType =
      zio.aws.emr.model.InstanceFleetType.wrap(impl.instanceFleetType())
    override val targetOnDemandCapacity: Option[WholeNumber] = scala
      .Option(impl.targetOnDemandCapacity())
      .map(value => zio.aws.emr.model.primitives.WholeNumber(value))
    override val targetSpotCapacity: Option[WholeNumber] = scala
      .Option(impl.targetSpotCapacity())
      .map(value => zio.aws.emr.model.primitives.WholeNumber(value))
    override val instanceTypeConfigs
        : Option[List[zio.aws.emr.model.InstanceTypeConfig.ReadOnly]] = scala
      .Option(impl.instanceTypeConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.InstanceTypeConfig.wrap(item)
        }.toList
      )
    override val launchSpecifications: Option[
      zio.aws.emr.model.InstanceFleetProvisioningSpecifications.ReadOnly
    ] = scala
      .Option(impl.launchSpecifications())
      .map(value =>
        zio.aws.emr.model.InstanceFleetProvisioningSpecifications.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.InstanceFleetConfig
  ): zio.aws.emr.model.InstanceFleetConfig.ReadOnly = new Wrapper(impl)
}
