package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class HadoopJarStepConfig(
    properties: Option[Iterable[zio.aws.emr.model.KeyValue]] = None,
    jar: XmlString,
    mainClass: Option[XmlString] = None,
    args: Option[Iterable[XmlString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.HadoopJarStepConfig = {
    import HadoopJarStepConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.HadoopJarStepConfig
      .builder()
      .optionallyWith(
        properties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.properties)
      .jar(XmlString.unwrap(jar): java.lang.String)
      .optionallyWith(
        mainClass.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.mainClass)
      .optionallyWith(
        args.map(value =>
          value.map { item =>
            XmlString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.args)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.HadoopJarStepConfig.ReadOnly =
    zio.aws.emr.model.HadoopJarStepConfig.wrap(buildAwsValue())
}
object HadoopJarStepConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.HadoopJarStepConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.HadoopJarStepConfig =
      zio.aws.emr.model.HadoopJarStepConfig(
        properties.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        jar,
        mainClass.map(value => value),
        args.map(value => value)
      )
    def properties: Option[List[zio.aws.emr.model.KeyValue.ReadOnly]]
    def jar: XmlString
    def mainClass: Option[XmlString]
    def args: Option[List[XmlString]]
    def getProperties
        : ZIO[Any, AwsError, List[zio.aws.emr.model.KeyValue.ReadOnly]] =
      AwsError.unwrapOptionField("properties", properties)
    def getJar: ZIO[Any, Nothing, XmlString] = ZIO.succeed(jar)
    def getMainClass: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("mainClass", mainClass)
    def getArgs: ZIO[Any, AwsError, List[XmlString]] =
      AwsError.unwrapOptionField("args", args)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.HadoopJarStepConfig
  ) extends zio.aws.emr.model.HadoopJarStepConfig.ReadOnly {
    override val properties: Option[List[zio.aws.emr.model.KeyValue.ReadOnly]] =
      scala
        .Option(impl.properties())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.KeyValue.wrap(item)
          }.toList
        )
    override val jar: XmlString =
      zio.aws.emr.model.primitives.XmlString(impl.jar())
    override val mainClass: Option[XmlString] = scala
      .Option(impl.mainClass())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val args: Option[List[XmlString]] = scala
      .Option(impl.args())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.primitives.XmlString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.HadoopJarStepConfig
  ): zio.aws.emr.model.HadoopJarStepConfig.ReadOnly = new Wrapper(impl)
}
