package zio.aws.emr.model
import zio.aws.emr.model.primitives.{XmlString, XmlStringMaxLen256}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateStudioRequest(
    name: XmlStringMaxLen256,
    description: Option[XmlStringMaxLen256] = None,
    authMode: zio.aws.emr.model.AuthMode,
    vpcId: XmlStringMaxLen256,
    subnetIds: Iterable[String],
    serviceRole: XmlString,
    userRole: Option[XmlString] = None,
    workspaceSecurityGroupId: XmlStringMaxLen256,
    engineSecurityGroupId: XmlStringMaxLen256,
    defaultS3Location: XmlString,
    idpAuthUrl: Option[XmlString] = None,
    idpRelayStateParameterName: Option[XmlStringMaxLen256] = None,
    tags: Option[Iterable[zio.aws.emr.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.CreateStudioRequest = {
    import CreateStudioRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.CreateStudioRequest
      .builder()
      .name(XmlStringMaxLen256.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.description)
      .authMode(authMode.unwrap)
      .vpcId(XmlStringMaxLen256.unwrap(vpcId): java.lang.String)
      .subnetIds(subnetIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .serviceRole(XmlString.unwrap(serviceRole): java.lang.String)
      .optionallyWith(
        userRole.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.userRole)
      .workspaceSecurityGroupId(
        XmlStringMaxLen256.unwrap(workspaceSecurityGroupId): java.lang.String
      )
      .engineSecurityGroupId(
        XmlStringMaxLen256.unwrap(engineSecurityGroupId): java.lang.String
      )
      .defaultS3Location(XmlString.unwrap(defaultS3Location): java.lang.String)
      .optionallyWith(
        idpAuthUrl.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.idpAuthUrl)
      .optionallyWith(
        idpRelayStateParameterName.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.idpRelayStateParameterName)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.CreateStudioRequest.ReadOnly =
    zio.aws.emr.model.CreateStudioRequest.wrap(buildAwsValue())
}
object CreateStudioRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.CreateStudioRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.CreateStudioRequest =
      zio.aws.emr.model.CreateStudioRequest(
        name,
        description.map(value => value),
        authMode,
        vpcId,
        subnetIds,
        serviceRole,
        userRole.map(value => value),
        workspaceSecurityGroupId,
        engineSecurityGroupId,
        defaultS3Location,
        idpAuthUrl.map(value => value),
        idpRelayStateParameterName.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: XmlStringMaxLen256
    def description: Option[XmlStringMaxLen256]
    def authMode: zio.aws.emr.model.AuthMode
    def vpcId: XmlStringMaxLen256
    def subnetIds: List[String]
    def serviceRole: XmlString
    def userRole: Option[XmlString]
    def workspaceSecurityGroupId: XmlStringMaxLen256
    def engineSecurityGroupId: XmlStringMaxLen256
    def defaultS3Location: XmlString
    def idpAuthUrl: Option[XmlString]
    def idpRelayStateParameterName: Option[XmlStringMaxLen256]
    def tags: Option[List[zio.aws.emr.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, XmlStringMaxLen256] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("description", description)
    def getAuthMode: ZIO[Any, Nothing, zio.aws.emr.model.AuthMode] =
      ZIO.succeed(authMode)
    def getVpcId: ZIO[Any, Nothing, XmlStringMaxLen256] = ZIO.succeed(vpcId)
    def getSubnetIds: ZIO[Any, Nothing, List[String]] = ZIO.succeed(subnetIds)
    def getServiceRole: ZIO[Any, Nothing, XmlString] = ZIO.succeed(serviceRole)
    def getUserRole: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("userRole", userRole)
    def getWorkspaceSecurityGroupId: ZIO[Any, Nothing, XmlStringMaxLen256] =
      ZIO.succeed(workspaceSecurityGroupId)
    def getEngineSecurityGroupId: ZIO[Any, Nothing, XmlStringMaxLen256] =
      ZIO.succeed(engineSecurityGroupId)
    def getDefaultS3Location: ZIO[Any, Nothing, XmlString] =
      ZIO.succeed(defaultS3Location)
    def getIdpAuthUrl: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("idpAuthUrl", idpAuthUrl)
    def getIdpRelayStateParameterName: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField(
        "idpRelayStateParameterName",
        idpRelayStateParameterName
      )
    def getTags: ZIO[Any, AwsError, List[zio.aws.emr.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.CreateStudioRequest
  ) extends zio.aws.emr.model.CreateStudioRequest.ReadOnly {
    override val name: XmlStringMaxLen256 =
      zio.aws.emr.model.primitives.XmlStringMaxLen256(impl.name())
    override val description: Option[XmlStringMaxLen256] = scala
      .Option(impl.description())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val authMode: zio.aws.emr.model.AuthMode =
      zio.aws.emr.model.AuthMode.wrap(impl.authMode())
    override val vpcId: XmlStringMaxLen256 =
      zio.aws.emr.model.primitives.XmlStringMaxLen256(impl.vpcId())
    override val subnetIds: List[String] = impl
      .subnetIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val serviceRole: XmlString =
      zio.aws.emr.model.primitives.XmlString(impl.serviceRole())
    override val userRole: Option[XmlString] = scala
      .Option(impl.userRole())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val workspaceSecurityGroupId: XmlStringMaxLen256 =
      zio.aws.emr.model.primitives
        .XmlStringMaxLen256(impl.workspaceSecurityGroupId())
    override val engineSecurityGroupId: XmlStringMaxLen256 =
      zio.aws.emr.model.primitives
        .XmlStringMaxLen256(impl.engineSecurityGroupId())
    override val defaultS3Location: XmlString =
      zio.aws.emr.model.primitives.XmlString(impl.defaultS3Location())
    override val idpAuthUrl: Option[XmlString] = scala
      .Option(impl.idpAuthUrl())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val idpRelayStateParameterName: Option[XmlStringMaxLen256] = scala
      .Option(impl.idpRelayStateParameterName())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val tags: Option[List[zio.aws.emr.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.CreateStudioRequest
  ): zio.aws.emr.model.CreateStudioRequest.ReadOnly = new Wrapper(impl)
}
