package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlStringMaxLen256
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AddJobFlowStepsResponse(
    stepIds: Option[Iterable[XmlStringMaxLen256]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.AddJobFlowStepsResponse = {
    import AddJobFlowStepsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.AddJobFlowStepsResponse
      .builder()
      .optionallyWith(
        stepIds.map(value =>
          value.map { item =>
            XmlStringMaxLen256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.stepIds)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.AddJobFlowStepsResponse.ReadOnly =
    zio.aws.emr.model.AddJobFlowStepsResponse.wrap(buildAwsValue())
}
object AddJobFlowStepsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.AddJobFlowStepsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.AddJobFlowStepsResponse =
      zio.aws.emr.model.AddJobFlowStepsResponse(stepIds.map(value => value))
    def stepIds: Option[List[XmlStringMaxLen256]]
    def getStepIds: ZIO[Any, AwsError, List[XmlStringMaxLen256]] =
      AwsError.unwrapOptionField("stepIds", stepIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.AddJobFlowStepsResponse
  ) extends zio.aws.emr.model.AddJobFlowStepsResponse.ReadOnly {
    override val stepIds: Option[List[XmlStringMaxLen256]] = scala
      .Option(impl.stepIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.primitives.XmlStringMaxLen256(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.AddJobFlowStepsResponse
  ): zio.aws.emr.model.AddJobFlowStepsResponse.ReadOnly = new Wrapper(impl)
}
