package zio.aws.emr.model
import zio.aws.emr.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VolumeSpecification(
    volumeType: String,
    iops: Option[Integer] = None,
    sizeInGB: Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.VolumeSpecification = {
    import VolumeSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.VolumeSpecification
      .builder()
      .volumeType(volumeType: java.lang.String)
      .optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops)
      .sizeInGB(sizeInGB: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.VolumeSpecification.ReadOnly =
    zio.aws.emr.model.VolumeSpecification.wrap(buildAwsValue())
}
object VolumeSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.VolumeSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.VolumeSpecification = zio.aws.emr.model
      .VolumeSpecification(volumeType, iops.map(value => value), sizeInGB)
    def volumeType: String
    def iops: Option[Integer]
    def sizeInGB: Integer
    def getVolumeType: ZIO[Any, Nothing, String] = ZIO.succeed(volumeType)
    def getIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("iops", iops)
    def getSizeInGB: ZIO[Any, Nothing, Integer] = ZIO.succeed(sizeInGB)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.VolumeSpecification
  ) extends zio.aws.emr.model.VolumeSpecification.ReadOnly {
    override val volumeType: String = impl.volumeType(): String
    override val iops: Option[Integer] =
      scala.Option(impl.iops()).map(value => value: Integer)
    override val sizeInGB: Integer = impl.sizeInGB(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.VolumeSpecification
  ): zio.aws.emr.model.VolumeSpecification.ReadOnly = new Wrapper(impl)
}
