package zio.aws.emr.model
import zio.aws.emr.model.primitives.StepId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StepSummary(
    id: Option[StepId] = None,
    name: Option[String] = None,
    config: Option[zio.aws.emr.model.HadoopStepConfig] = None,
    actionOnFailure: Option[zio.aws.emr.model.ActionOnFailure] = None,
    status: Option[zio.aws.emr.model.StepStatus] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.emr.model.StepSummary = {
    import StepSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.StepSummary
      .builder()
      .optionallyWith(id.map(value => StepId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(config.map(value => value.buildAwsValue()))(_.config)
      .optionallyWith(actionOnFailure.map(value => value.unwrap))(
        _.actionOnFailure
      )
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.StepSummary.ReadOnly =
    zio.aws.emr.model.StepSummary.wrap(buildAwsValue())
}
object StepSummary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.StepSummary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.StepSummary =
      zio.aws.emr.model.StepSummary(
        id.map(value => value),
        name.map(value => value),
        config.map(value => value.asEditable),
        actionOnFailure.map(value => value),
        status.map(value => value.asEditable)
      )
    def id: Option[StepId]
    def name: Option[String]
    def config: Option[zio.aws.emr.model.HadoopStepConfig.ReadOnly]
    def actionOnFailure: Option[zio.aws.emr.model.ActionOnFailure]
    def status: Option[zio.aws.emr.model.StepStatus.ReadOnly]
    def getId: ZIO[Any, AwsError, StepId] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getConfig
        : ZIO[Any, AwsError, zio.aws.emr.model.HadoopStepConfig.ReadOnly] =
      AwsError.unwrapOptionField("config", config)
    def getActionOnFailure
        : ZIO[Any, AwsError, zio.aws.emr.model.ActionOnFailure] =
      AwsError.unwrapOptionField("actionOnFailure", actionOnFailure)
    def getStatus: ZIO[Any, AwsError, zio.aws.emr.model.StepStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.StepSummary
  ) extends zio.aws.emr.model.StepSummary.ReadOnly {
    override val id: Option[StepId] = scala
      .Option(impl.id())
      .map(value => zio.aws.emr.model.primitives.StepId(value))
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val config: Option[zio.aws.emr.model.HadoopStepConfig.ReadOnly] =
      scala
        .Option(impl.config())
        .map(value => zio.aws.emr.model.HadoopStepConfig.wrap(value))
    override val actionOnFailure: Option[zio.aws.emr.model.ActionOnFailure] =
      scala
        .Option(impl.actionOnFailure())
        .map(value => zio.aws.emr.model.ActionOnFailure.wrap(value))
    override val status: Option[zio.aws.emr.model.StepStatus.ReadOnly] = scala
      .Option(impl.status())
      .map(value => zio.aws.emr.model.StepStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.StepSummary
  ): zio.aws.emr.model.StepSummary.ReadOnly = new Wrapper(impl)
}
