package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait PlacementGroupStrategy {
  def unwrap: software.amazon.awssdk.services.emr.model.PlacementGroupStrategy
}
object PlacementGroupStrategy {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.PlacementGroupStrategy
  ): zio.aws.emr.model.PlacementGroupStrategy = value match {
    case software.amazon.awssdk.services.emr.model.PlacementGroupStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.PlacementGroupStrategy.SPREAD =>
      val r = SPREAD
      r
    case software.amazon.awssdk.services.emr.model.PlacementGroupStrategy.PARTITION =>
      val r = PARTITION
      r
    case software.amazon.awssdk.services.emr.model.PlacementGroupStrategy.CLUSTER =>
      val r = CLUSTER
      r
    case software.amazon.awssdk.services.emr.model.PlacementGroupStrategy.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.emr.model.PlacementGroupStrategy {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.PlacementGroupStrategy =
      software.amazon.awssdk.services.emr.model.PlacementGroupStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object SPREAD extends zio.aws.emr.model.PlacementGroupStrategy {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.PlacementGroupStrategy =
      software.amazon.awssdk.services.emr.model.PlacementGroupStrategy.SPREAD
  }
  case object PARTITION extends zio.aws.emr.model.PlacementGroupStrategy {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.PlacementGroupStrategy =
      software.amazon.awssdk.services.emr.model.PlacementGroupStrategy.PARTITION
  }
  case object CLUSTER extends zio.aws.emr.model.PlacementGroupStrategy {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.PlacementGroupStrategy =
      software.amazon.awssdk.services.emr.model.PlacementGroupStrategy.CLUSTER
  }
  case object NONE extends zio.aws.emr.model.PlacementGroupStrategy {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.PlacementGroupStrategy =
      software.amazon.awssdk.services.emr.model.PlacementGroupStrategy.NONE
  }
}
