package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeStudioResponse(
    studio: Option[zio.aws.emr.model.Studio] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.DescribeStudioResponse = {
    import DescribeStudioResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.DescribeStudioResponse
      .builder()
      .optionallyWith(studio.map(value => value.buildAwsValue()))(_.studio)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.DescribeStudioResponse.ReadOnly =
    zio.aws.emr.model.DescribeStudioResponse.wrap(buildAwsValue())
}
object DescribeStudioResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.DescribeStudioResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.DescribeStudioResponse = zio.aws.emr.model
      .DescribeStudioResponse(studio.map(value => value.asEditable))
    def studio: Option[zio.aws.emr.model.Studio.ReadOnly]
    def getStudio: ZIO[Any, AwsError, zio.aws.emr.model.Studio.ReadOnly] =
      AwsError.unwrapOptionField("studio", studio)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.DescribeStudioResponse
  ) extends zio.aws.emr.model.DescribeStudioResponse.ReadOnly {
    override val studio: Option[zio.aws.emr.model.Studio.ReadOnly] = scala
      .Option(impl.studio())
      .map(value => zio.aws.emr.model.Studio.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.DescribeStudioResponse
  ): zio.aws.emr.model.DescribeStudioResponse.ReadOnly = new Wrapper(impl)
}
