package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClusterStatus(
    state: Option[zio.aws.emr.model.ClusterState] = None,
    stateChangeReason: Option[zio.aws.emr.model.ClusterStateChangeReason] =
      None,
    timeline: Option[zio.aws.emr.model.ClusterTimeline] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ClusterStatus = {
    import ClusterStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ClusterStatus
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateChangeReason.map(value => value.buildAwsValue()))(
        _.stateChangeReason
      )
      .optionallyWith(timeline.map(value => value.buildAwsValue()))(_.timeline)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ClusterStatus.ReadOnly =
    zio.aws.emr.model.ClusterStatus.wrap(buildAwsValue())
}
object ClusterStatus {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.ClusterStatus] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ClusterStatus =
      zio.aws.emr.model.ClusterStatus(
        state.map(value => value),
        stateChangeReason.map(value => value.asEditable),
        timeline.map(value => value.asEditable)
      )
    def state: Option[zio.aws.emr.model.ClusterState]
    def stateChangeReason
        : Option[zio.aws.emr.model.ClusterStateChangeReason.ReadOnly]
    def timeline: Option[zio.aws.emr.model.ClusterTimeline.ReadOnly]
    def getState: ZIO[Any, AwsError, zio.aws.emr.model.ClusterState] =
      AwsError.unwrapOptionField("state", state)
    def getStateChangeReason: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.ClusterStateChangeReason.ReadOnly
    ] = AwsError.unwrapOptionField("stateChangeReason", stateChangeReason)
    def getTimeline
        : ZIO[Any, AwsError, zio.aws.emr.model.ClusterTimeline.ReadOnly] =
      AwsError.unwrapOptionField("timeline", timeline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ClusterStatus
  ) extends zio.aws.emr.model.ClusterStatus.ReadOnly {
    override val state: Option[zio.aws.emr.model.ClusterState] = scala
      .Option(impl.state())
      .map(value => zio.aws.emr.model.ClusterState.wrap(value))
    override val stateChangeReason
        : Option[zio.aws.emr.model.ClusterStateChangeReason.ReadOnly] = scala
      .Option(impl.stateChangeReason())
      .map(value => zio.aws.emr.model.ClusterStateChangeReason.wrap(value))
    override val timeline: Option[zio.aws.emr.model.ClusterTimeline.ReadOnly] =
      scala
        .Option(impl.timeline())
        .map(value => zio.aws.emr.model.ClusterTimeline.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ClusterStatus
  ): zio.aws.emr.model.ClusterStatus.ReadOnly = new Wrapper(impl)
}
