package zio.aws.emr.model
import zio.aws.emr.model.primitives.{Date, XmlStringMaxLen256}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class NotebookExecutionSummary(
    notebookExecutionId: Option[XmlStringMaxLen256] = None,
    editorId: Option[XmlStringMaxLen256] = None,
    notebookExecutionName: Option[XmlStringMaxLen256] = None,
    status: Option[zio.aws.emr.model.NotebookExecutionStatus] = None,
    startTime: Option[Date] = None,
    endTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.NotebookExecutionSummary = {
    import NotebookExecutionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.NotebookExecutionSummary
      .builder()
      .optionallyWith(
        notebookExecutionId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.notebookExecutionId)
      .optionallyWith(
        editorId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.editorId)
      .optionallyWith(
        notebookExecutionName.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.notebookExecutionName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(startTime.map(value => Date.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Date.unwrap(value): Instant))(
        _.endTime
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.NotebookExecutionSummary.ReadOnly =
    zio.aws.emr.model.NotebookExecutionSummary.wrap(buildAwsValue())
}
object NotebookExecutionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.NotebookExecutionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.NotebookExecutionSummary =
      zio.aws.emr.model.NotebookExecutionSummary(
        notebookExecutionId.map(value => value),
        editorId.map(value => value),
        notebookExecutionName.map(value => value),
        status.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value)
      )
    def notebookExecutionId: Option[XmlStringMaxLen256]
    def editorId: Option[XmlStringMaxLen256]
    def notebookExecutionName: Option[XmlStringMaxLen256]
    def status: Option[zio.aws.emr.model.NotebookExecutionStatus]
    def startTime: Option[Date]
    def endTime: Option[Date]
    def getNotebookExecutionId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("notebookExecutionId", notebookExecutionId)
    def getEditorId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("editorId", editorId)
    def getNotebookExecutionName: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("notebookExecutionName", notebookExecutionName)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.emr.model.NotebookExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStartTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.NotebookExecutionSummary
  ) extends zio.aws.emr.model.NotebookExecutionSummary.ReadOnly {
    override val notebookExecutionId: Option[XmlStringMaxLen256] = scala
      .Option(impl.notebookExecutionId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val editorId: Option[XmlStringMaxLen256] = scala
      .Option(impl.editorId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val notebookExecutionName: Option[XmlStringMaxLen256] = scala
      .Option(impl.notebookExecutionName())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val status: Option[zio.aws.emr.model.NotebookExecutionStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.emr.model.NotebookExecutionStatus.wrap(value))
    override val startTime: Option[Date] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
    override val endTime: Option[Date] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.NotebookExecutionSummary
  ): zio.aws.emr.model.NotebookExecutionSummary.ReadOnly = new Wrapper(impl)
}
