package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait StepStateChangeReasonCode {
  def unwrap
      : software.amazon.awssdk.services.emr.model.StepStateChangeReasonCode
}
object StepStateChangeReasonCode {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.StepStateChangeReasonCode
  ): zio.aws.emr.model.StepStateChangeReasonCode = value match {
    case software.amazon.awssdk.services.emr.model.StepStateChangeReasonCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.StepStateChangeReasonCode.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.emr.model.StepStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.StepStateChangeReasonCode =
      software.amazon.awssdk.services.emr.model.StepStateChangeReasonCode.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.emr.model.StepStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.StepStateChangeReasonCode =
      software.amazon.awssdk.services.emr.model.StepStateChangeReasonCode.NONE
  }
}
