package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ScalingRule(
    name: String,
    description: Option[String] = None,
    action: zio.aws.emr.model.ScalingAction,
    trigger: zio.aws.emr.model.ScalingTrigger
) {
  def buildAwsValue(): software.amazon.awssdk.services.emr.model.ScalingRule = {
    import ScalingRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ScalingRule
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .action(action.buildAwsValue())
      .trigger(trigger.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ScalingRule.ReadOnly =
    zio.aws.emr.model.ScalingRule.wrap(buildAwsValue())
}
object ScalingRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.ScalingRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ScalingRule =
      zio.aws.emr.model.ScalingRule(
        name,
        description.map(value => value),
        action.asEditable,
        trigger.asEditable
      )
    def name: String
    def description: Option[String]
    def action: zio.aws.emr.model.ScalingAction.ReadOnly
    def trigger: zio.aws.emr.model.ScalingTrigger.ReadOnly
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getAction: ZIO[Any, Nothing, zio.aws.emr.model.ScalingAction.ReadOnly] =
      ZIO.succeed(action)
    def getTrigger
        : ZIO[Any, Nothing, zio.aws.emr.model.ScalingTrigger.ReadOnly] =
      ZIO.succeed(trigger)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ScalingRule
  ) extends zio.aws.emr.model.ScalingRule.ReadOnly {
    override val name: String = impl.name(): String
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val action: zio.aws.emr.model.ScalingAction.ReadOnly =
      zio.aws.emr.model.ScalingAction.wrap(impl.action())
    override val trigger: zio.aws.emr.model.ScalingTrigger.ReadOnly =
      zio.aws.emr.model.ScalingTrigger.wrap(impl.trigger())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ScalingRule
  ): zio.aws.emr.model.ScalingRule.ReadOnly = new Wrapper(impl)
}
