package zio.aws.emr.model
import zio.aws.emr.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyClusterResponse(
    stepConcurrencyLevel: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ModifyClusterResponse = {
    import ModifyClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ModifyClusterResponse
      .builder()
      .optionallyWith(
        stepConcurrencyLevel.map(value => value: java.lang.Integer)
      )(_.stepConcurrencyLevel)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ModifyClusterResponse.ReadOnly =
    zio.aws.emr.model.ModifyClusterResponse.wrap(buildAwsValue())
}
object ModifyClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ModifyClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ModifyClusterResponse = zio.aws.emr.model
      .ModifyClusterResponse(stepConcurrencyLevel.map(value => value))
    def stepConcurrencyLevel: Option[Integer]
    def getStepConcurrencyLevel: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("stepConcurrencyLevel", stepConcurrencyLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ModifyClusterResponse
  ) extends zio.aws.emr.model.ModifyClusterResponse.ReadOnly {
    override val stepConcurrencyLevel: Option[Integer] =
      scala.Option(impl.stepConcurrencyLevel()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ModifyClusterResponse
  ): zio.aws.emr.model.ModifyClusterResponse.ReadOnly = new Wrapper(impl)
}
