package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceStatus(
    state: Option[zio.aws.emr.model.InstanceState] = None,
    stateChangeReason: Option[zio.aws.emr.model.InstanceStateChangeReason] =
      None,
    timeline: Option[zio.aws.emr.model.InstanceTimeline] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.InstanceStatus = {
    import InstanceStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.InstanceStatus
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateChangeReason.map(value => value.buildAwsValue()))(
        _.stateChangeReason
      )
      .optionallyWith(timeline.map(value => value.buildAwsValue()))(_.timeline)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.InstanceStatus.ReadOnly =
    zio.aws.emr.model.InstanceStatus.wrap(buildAwsValue())
}
object InstanceStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.InstanceStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.InstanceStatus =
      zio.aws.emr.model.InstanceStatus(
        state.map(value => value),
        stateChangeReason.map(value => value.asEditable),
        timeline.map(value => value.asEditable)
      )
    def state: Option[zio.aws.emr.model.InstanceState]
    def stateChangeReason
        : Option[zio.aws.emr.model.InstanceStateChangeReason.ReadOnly]
    def timeline: Option[zio.aws.emr.model.InstanceTimeline.ReadOnly]
    def getState: ZIO[Any, AwsError, zio.aws.emr.model.InstanceState] =
      AwsError.unwrapOptionField("state", state)
    def getStateChangeReason: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.InstanceStateChangeReason.ReadOnly
    ] = AwsError.unwrapOptionField("stateChangeReason", stateChangeReason)
    def getTimeline
        : ZIO[Any, AwsError, zio.aws.emr.model.InstanceTimeline.ReadOnly] =
      AwsError.unwrapOptionField("timeline", timeline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.InstanceStatus
  ) extends zio.aws.emr.model.InstanceStatus.ReadOnly {
    override val state: Option[zio.aws.emr.model.InstanceState] = scala
      .Option(impl.state())
      .map(value => zio.aws.emr.model.InstanceState.wrap(value))
    override val stateChangeReason
        : Option[zio.aws.emr.model.InstanceStateChangeReason.ReadOnly] = scala
      .Option(impl.stateChangeReason())
      .map(value => zio.aws.emr.model.InstanceStateChangeReason.wrap(value))
    override val timeline: Option[zio.aws.emr.model.InstanceTimeline.ReadOnly] =
      scala
        .Option(impl.timeline())
        .map(value => zio.aws.emr.model.InstanceTimeline.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.InstanceStatus
  ): zio.aws.emr.model.InstanceStatus.ReadOnly = new Wrapper(impl)
}
