package zio.aws.emr.model
import zio.aws.emr.model.primitives.{InstanceId, Integer, XmlStringMaxLen256}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceGroupModifyConfig(
    instanceGroupId: XmlStringMaxLen256,
    instanceCount: Option[Integer] = None,
    ec2InstanceIdsToTerminate: Option[Iterable[InstanceId]] = None,
    shrinkPolicy: Option[zio.aws.emr.model.ShrinkPolicy] = None,
    configurations: Option[Iterable[zio.aws.emr.model.Configuration]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.InstanceGroupModifyConfig = {
    import InstanceGroupModifyConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.InstanceGroupModifyConfig
      .builder()
      .instanceGroupId(
        XmlStringMaxLen256.unwrap(instanceGroupId): java.lang.String
      )
      .optionallyWith(instanceCount.map(value => value: java.lang.Integer))(
        _.instanceCount
      )
      .optionallyWith(
        ec2InstanceIdsToTerminate.map(value =>
          value.map { item =>
            InstanceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ec2InstanceIdsToTerminate)
      .optionallyWith(shrinkPolicy.map(value => value.buildAwsValue()))(
        _.shrinkPolicy
      )
      .optionallyWith(
        configurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configurations)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.InstanceGroupModifyConfig.ReadOnly =
    zio.aws.emr.model.InstanceGroupModifyConfig.wrap(buildAwsValue())
}
object InstanceGroupModifyConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.InstanceGroupModifyConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.InstanceGroupModifyConfig =
      zio.aws.emr.model.InstanceGroupModifyConfig(
        instanceGroupId,
        instanceCount.map(value => value),
        ec2InstanceIdsToTerminate.map(value => value),
        shrinkPolicy.map(value => value.asEditable),
        configurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def instanceGroupId: XmlStringMaxLen256
    def instanceCount: Option[Integer]
    def ec2InstanceIdsToTerminate: Option[List[InstanceId]]
    def shrinkPolicy: Option[zio.aws.emr.model.ShrinkPolicy.ReadOnly]
    def configurations: Option[List[zio.aws.emr.model.Configuration.ReadOnly]]
    def getInstanceGroupId: ZIO[Any, Nothing, XmlStringMaxLen256] =
      ZIO.succeed(instanceGroupId)
    def getInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getEc2InstanceIdsToTerminate: ZIO[Any, AwsError, List[InstanceId]] =
      AwsError.unwrapOptionField(
        "ec2InstanceIdsToTerminate",
        ec2InstanceIdsToTerminate
      )
    def getShrinkPolicy
        : ZIO[Any, AwsError, zio.aws.emr.model.ShrinkPolicy.ReadOnly] =
      AwsError.unwrapOptionField("shrinkPolicy", shrinkPolicy)
    def getConfigurations
        : ZIO[Any, AwsError, List[zio.aws.emr.model.Configuration.ReadOnly]] =
      AwsError.unwrapOptionField("configurations", configurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.InstanceGroupModifyConfig
  ) extends zio.aws.emr.model.InstanceGroupModifyConfig.ReadOnly {
    override val instanceGroupId: XmlStringMaxLen256 =
      zio.aws.emr.model.primitives.XmlStringMaxLen256(impl.instanceGroupId())
    override val instanceCount: Option[Integer] =
      scala.Option(impl.instanceCount()).map(value => value: Integer)
    override val ec2InstanceIdsToTerminate: Option[List[InstanceId]] = scala
      .Option(impl.ec2InstanceIdsToTerminate())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.primitives.InstanceId(item)
        }.toList
      )
    override val shrinkPolicy: Option[zio.aws.emr.model.ShrinkPolicy.ReadOnly] =
      scala
        .Option(impl.shrinkPolicy())
        .map(value => zio.aws.emr.model.ShrinkPolicy.wrap(value))
    override val configurations
        : Option[List[zio.aws.emr.model.Configuration.ReadOnly]] = scala
      .Option(impl.configurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.Configuration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.InstanceGroupModifyConfig
  ): zio.aws.emr.model.InstanceGroupModifyConfig.ReadOnly = new Wrapper(impl)
}
