package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait InstanceCollectionType {
  def unwrap: software.amazon.awssdk.services.emr.model.InstanceCollectionType
}
object InstanceCollectionType {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.InstanceCollectionType
  ): zio.aws.emr.model.InstanceCollectionType = value match {
    case software.amazon.awssdk.services.emr.model.InstanceCollectionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.InstanceCollectionType.INSTANCE_FLEET =>
      val r = INSTANCE_FLEET
      r
    case software.amazon.awssdk.services.emr.model.InstanceCollectionType.INSTANCE_GROUP =>
      val r = INSTANCE_GROUP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.emr.model.InstanceCollectionType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceCollectionType =
      software.amazon.awssdk.services.emr.model.InstanceCollectionType.UNKNOWN_TO_SDK_VERSION
  }
  case object INSTANCE_FLEET extends zio.aws.emr.model.InstanceCollectionType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceCollectionType =
      software.amazon.awssdk.services.emr.model.InstanceCollectionType.INSTANCE_FLEET
  }
  case object INSTANCE_GROUP extends zio.aws.emr.model.InstanceCollectionType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceCollectionType =
      software.amazon.awssdk.services.emr.model.InstanceCollectionType.INSTANCE_GROUP
  }
}
