package zio.aws.emr.model
import zio.aws.emr.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EbsBlockDeviceConfig(
    volumeSpecification: zio.aws.emr.model.VolumeSpecification,
    volumesPerInstance: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.EbsBlockDeviceConfig = {
    import EbsBlockDeviceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.EbsBlockDeviceConfig
      .builder()
      .volumeSpecification(volumeSpecification.buildAwsValue())
      .optionallyWith(
        volumesPerInstance.map(value => value: java.lang.Integer)
      )(_.volumesPerInstance)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.EbsBlockDeviceConfig.ReadOnly =
    zio.aws.emr.model.EbsBlockDeviceConfig.wrap(buildAwsValue())
}
object EbsBlockDeviceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.EbsBlockDeviceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.EbsBlockDeviceConfig =
      zio.aws.emr.model.EbsBlockDeviceConfig(
        volumeSpecification.asEditable,
        volumesPerInstance.map(value => value)
      )
    def volumeSpecification: zio.aws.emr.model.VolumeSpecification.ReadOnly
    def volumesPerInstance: Option[Integer]
    def getVolumeSpecification
        : ZIO[Any, Nothing, zio.aws.emr.model.VolumeSpecification.ReadOnly] =
      ZIO.succeed(volumeSpecification)
    def getVolumesPerInstance: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("volumesPerInstance", volumesPerInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.EbsBlockDeviceConfig
  ) extends zio.aws.emr.model.EbsBlockDeviceConfig.ReadOnly {
    override val volumeSpecification
        : zio.aws.emr.model.VolumeSpecification.ReadOnly =
      zio.aws.emr.model.VolumeSpecification.wrap(impl.volumeSpecification())
    override val volumesPerInstance: Option[Integer] =
      scala.Option(impl.volumesPerInstance()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.EbsBlockDeviceConfig
  ): zio.aws.emr.model.EbsBlockDeviceConfig.ReadOnly = new Wrapper(impl)
}
