package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AutoScalingPolicyStatus(
    state: Option[zio.aws.emr.model.AutoScalingPolicyState] = None,
    stateChangeReason: Option[
      zio.aws.emr.model.AutoScalingPolicyStateChangeReason
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.AutoScalingPolicyStatus = {
    import AutoScalingPolicyStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.AutoScalingPolicyStatus
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateChangeReason.map(value => value.buildAwsValue()))(
        _.stateChangeReason
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.AutoScalingPolicyStatus.ReadOnly =
    zio.aws.emr.model.AutoScalingPolicyStatus.wrap(buildAwsValue())
}
object AutoScalingPolicyStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.AutoScalingPolicyStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.AutoScalingPolicyStatus =
      zio.aws.emr.model.AutoScalingPolicyStatus(
        state.map(value => value),
        stateChangeReason.map(value => value.asEditable)
      )
    def state: Option[zio.aws.emr.model.AutoScalingPolicyState]
    def stateChangeReason
        : Option[zio.aws.emr.model.AutoScalingPolicyStateChangeReason.ReadOnly]
    def getState: ZIO[Any, AwsError, zio.aws.emr.model.AutoScalingPolicyState] =
      AwsError.unwrapOptionField("state", state)
    def getStateChangeReason: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.AutoScalingPolicyStateChangeReason.ReadOnly
    ] = AwsError.unwrapOptionField("stateChangeReason", stateChangeReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.AutoScalingPolicyStatus
  ) extends zio.aws.emr.model.AutoScalingPolicyStatus.ReadOnly {
    override val state: Option[zio.aws.emr.model.AutoScalingPolicyState] = scala
      .Option(impl.state())
      .map(value => zio.aws.emr.model.AutoScalingPolicyState.wrap(value))
    override val stateChangeReason: Option[
      zio.aws.emr.model.AutoScalingPolicyStateChangeReason.ReadOnly
    ] = scala
      .Option(impl.stateChangeReason())
      .map(value =>
        zio.aws.emr.model.AutoScalingPolicyStateChangeReason.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.AutoScalingPolicyStatus
  ): zio.aws.emr.model.AutoScalingPolicyStatus.ReadOnly = new Wrapper(impl)
}
