package zio.aws.emr.model
import zio.aws.emr.model.primitives.Date
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StepTimeline(
    creationDateTime: Option[Date] = None,
    startDateTime: Option[Date] = None,
    endDateTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.StepTimeline = {
    import StepTimeline.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.StepTimeline
      .builder()
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(startDateTime.map(value => Date.unwrap(value): Instant))(
        _.startDateTime
      )
      .optionallyWith(endDateTime.map(value => Date.unwrap(value): Instant))(
        _.endDateTime
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.StepTimeline.ReadOnly =
    zio.aws.emr.model.StepTimeline.wrap(buildAwsValue())
}
object StepTimeline {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.StepTimeline] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.StepTimeline =
      zio.aws.emr.model.StepTimeline(
        creationDateTime.map(value => value),
        startDateTime.map(value => value),
        endDateTime.map(value => value)
      )
    def creationDateTime: Option[Date]
    def startDateTime: Option[Date]
    def endDateTime: Option[Date]
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getStartDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("startDateTime", startDateTime)
    def getEndDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("endDateTime", endDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.StepTimeline
  ) extends zio.aws.emr.model.StepTimeline.ReadOnly {
    override val creationDateTime: Option[Date] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
    override val startDateTime: Option[Date] = scala
      .Option(impl.startDateTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
    override val endDateTime: Option[Date] = scala
      .Option(impl.endDateTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.StepTimeline
  ): zio.aws.emr.model.StepTimeline.ReadOnly = new Wrapper(impl)
}
