package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait MarketType {
  def unwrap: software.amazon.awssdk.services.emr.model.MarketType
}
object MarketType {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.MarketType
  ): zio.aws.emr.model.MarketType = value match {
    case software.amazon.awssdk.services.emr.model.MarketType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.MarketType.ON_DEMAND =>
      val r = ON_DEMAND
      r
    case software.amazon.awssdk.services.emr.model.MarketType.SPOT =>
      val r = SPOT
      r
  }
  case object unknownToSdkVersion extends zio.aws.emr.model.MarketType {
    override def unwrap: software.amazon.awssdk.services.emr.model.MarketType =
      software.amazon.awssdk.services.emr.model.MarketType.UNKNOWN_TO_SDK_VERSION
  }
  case object ON_DEMAND extends zio.aws.emr.model.MarketType {
    override def unwrap: software.amazon.awssdk.services.emr.model.MarketType =
      software.amazon.awssdk.services.emr.model.MarketType.ON_DEMAND
  }
  case object SPOT extends zio.aws.emr.model.MarketType {
    override def unwrap: software.amazon.awssdk.services.emr.model.MarketType =
      software.amazon.awssdk.services.emr.model.MarketType.SPOT
  }
}
