package zio.aws.emr.model
import zio.aws.emr.model.primitives.{Integer, InstanceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceResizePolicy(
    instancesToTerminate: Option[Iterable[InstanceId]] = None,
    instancesToProtect: Option[Iterable[InstanceId]] = None,
    instanceTerminationTimeout: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.InstanceResizePolicy = {
    import InstanceResizePolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.InstanceResizePolicy
      .builder()
      .optionallyWith(
        instancesToTerminate.map(value =>
          value.map { item =>
            InstanceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instancesToTerminate)
      .optionallyWith(
        instancesToProtect.map(value =>
          value.map { item =>
            InstanceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instancesToProtect)
      .optionallyWith(
        instanceTerminationTimeout.map(value => value: java.lang.Integer)
      )(_.instanceTerminationTimeout)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.InstanceResizePolicy.ReadOnly =
    zio.aws.emr.model.InstanceResizePolicy.wrap(buildAwsValue())
}
object InstanceResizePolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.InstanceResizePolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.InstanceResizePolicy =
      zio.aws.emr.model.InstanceResizePolicy(
        instancesToTerminate.map(value => value),
        instancesToProtect.map(value => value),
        instanceTerminationTimeout.map(value => value)
      )
    def instancesToTerminate: Option[List[InstanceId]]
    def instancesToProtect: Option[List[InstanceId]]
    def instanceTerminationTimeout: Option[Integer]
    def getInstancesToTerminate: ZIO[Any, AwsError, List[InstanceId]] =
      AwsError.unwrapOptionField("instancesToTerminate", instancesToTerminate)
    def getInstancesToProtect: ZIO[Any, AwsError, List[InstanceId]] =
      AwsError.unwrapOptionField("instancesToProtect", instancesToProtect)
    def getInstanceTerminationTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "instanceTerminationTimeout",
        instanceTerminationTimeout
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.InstanceResizePolicy
  ) extends zio.aws.emr.model.InstanceResizePolicy.ReadOnly {
    override val instancesToTerminate: Option[List[InstanceId]] = scala
      .Option(impl.instancesToTerminate())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.primitives.InstanceId(item)
        }.toList
      )
    override val instancesToProtect: Option[List[InstanceId]] = scala
      .Option(impl.instancesToProtect())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.primitives.InstanceId(item)
        }.toList
      )
    override val instanceTerminationTimeout: Option[Integer] = scala
      .Option(impl.instanceTerminationTimeout())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.InstanceResizePolicy
  ): zio.aws.emr.model.InstanceResizePolicy.ReadOnly = new Wrapper(impl)
}
