package zio.aws.emr.model
import zio.aws.emr.model.primitives.{NonNegativeDouble, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CloudWatchAlarmDefinition(
    comparisonOperator: zio.aws.emr.model.ComparisonOperator,
    evaluationPeriods: Option[Integer] = None,
    metricName: String,
    namespace: Option[String] = None,
    period: Integer,
    statistic: Option[zio.aws.emr.model.Statistic] = None,
    threshold: NonNegativeDouble,
    unit: Option[zio.aws.emr.model.Unit] = None,
    dimensions: Option[Iterable[zio.aws.emr.model.MetricDimension]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.CloudWatchAlarmDefinition = {
    import CloudWatchAlarmDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.CloudWatchAlarmDefinition
      .builder()
      .comparisonOperator(comparisonOperator.unwrap)
      .optionallyWith(evaluationPeriods.map(value => value: java.lang.Integer))(
        _.evaluationPeriods
      )
      .metricName(metricName: java.lang.String)
      .optionallyWith(namespace.map(value => value: java.lang.String))(
        _.namespace
      )
      .period(period: java.lang.Integer)
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .threshold(NonNegativeDouble.unwrap(threshold): java.lang.Double)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.CloudWatchAlarmDefinition.ReadOnly =
    zio.aws.emr.model.CloudWatchAlarmDefinition.wrap(buildAwsValue())
}
object CloudWatchAlarmDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.CloudWatchAlarmDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.CloudWatchAlarmDefinition =
      zio.aws.emr.model.CloudWatchAlarmDefinition(
        comparisonOperator,
        evaluationPeriods.map(value => value),
        metricName,
        namespace.map(value => value),
        period,
        statistic.map(value => value),
        threshold,
        unit.map(value => value),
        dimensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def comparisonOperator: zio.aws.emr.model.ComparisonOperator
    def evaluationPeriods: Option[Integer]
    def metricName: String
    def namespace: Option[String]
    def period: Integer
    def statistic: Option[zio.aws.emr.model.Statistic]
    def threshold: NonNegativeDouble
    def unit: Option[zio.aws.emr.model.Unit]
    def dimensions: Option[List[zio.aws.emr.model.MetricDimension.ReadOnly]]
    def getComparisonOperator
        : ZIO[Any, Nothing, zio.aws.emr.model.ComparisonOperator] =
      ZIO.succeed(comparisonOperator)
    def getEvaluationPeriods: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("evaluationPeriods", evaluationPeriods)
    def getMetricName: ZIO[Any, Nothing, String] = ZIO.succeed(metricName)
    def getNamespace: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getPeriod: ZIO[Any, Nothing, Integer] = ZIO.succeed(period)
    def getStatistic: ZIO[Any, AwsError, zio.aws.emr.model.Statistic] =
      AwsError.unwrapOptionField("statistic", statistic)
    def getThreshold: ZIO[Any, Nothing, NonNegativeDouble] =
      ZIO.succeed(threshold)
    def getUnit: ZIO[Any, AwsError, zio.aws.emr.model.Unit] =
      AwsError.unwrapOptionField("unit", unit)
    def getDimensions
        : ZIO[Any, AwsError, List[zio.aws.emr.model.MetricDimension.ReadOnly]] =
      AwsError.unwrapOptionField("dimensions", dimensions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.CloudWatchAlarmDefinition
  ) extends zio.aws.emr.model.CloudWatchAlarmDefinition.ReadOnly {
    override val comparisonOperator: zio.aws.emr.model.ComparisonOperator =
      zio.aws.emr.model.ComparisonOperator.wrap(impl.comparisonOperator())
    override val evaluationPeriods: Option[Integer] =
      scala.Option(impl.evaluationPeriods()).map(value => value: Integer)
    override val metricName: String = impl.metricName(): String
    override val namespace: Option[String] =
      scala.Option(impl.namespace()).map(value => value: String)
    override val period: Integer = impl.period(): Integer
    override val statistic: Option[zio.aws.emr.model.Statistic] = scala
      .Option(impl.statistic())
      .map(value => zio.aws.emr.model.Statistic.wrap(value))
    override val threshold: NonNegativeDouble =
      zio.aws.emr.model.primitives.NonNegativeDouble(impl.threshold())
    override val unit: Option[zio.aws.emr.model.Unit] =
      scala.Option(impl.unit()).map(value => zio.aws.emr.model.Unit.wrap(value))
    override val dimensions
        : Option[List[zio.aws.emr.model.MetricDimension.ReadOnly]] = scala
      .Option(impl.dimensions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.MetricDimension.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.CloudWatchAlarmDefinition
  ): zio.aws.emr.model.CloudWatchAlarmDefinition.ReadOnly = new Wrapper(impl)
}
