package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PlacementGroupConfig(
    instanceRole: zio.aws.emr.model.InstanceRoleType,
    placementStrategy: Option[zio.aws.emr.model.PlacementGroupStrategy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.PlacementGroupConfig = {
    import PlacementGroupConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.PlacementGroupConfig
      .builder()
      .instanceRole(instanceRole.unwrap)
      .optionallyWith(placementStrategy.map(value => value.unwrap))(
        _.placementStrategy
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.PlacementGroupConfig.ReadOnly =
    zio.aws.emr.model.PlacementGroupConfig.wrap(buildAwsValue())
}
object PlacementGroupConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.PlacementGroupConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.PlacementGroupConfig = zio.aws.emr.model
      .PlacementGroupConfig(instanceRole, placementStrategy.map(value => value))
    def instanceRole: zio.aws.emr.model.InstanceRoleType
    def placementStrategy: Option[zio.aws.emr.model.PlacementGroupStrategy]
    def getInstanceRole: ZIO[Any, Nothing, zio.aws.emr.model.InstanceRoleType] =
      ZIO.succeed(instanceRole)
    def getPlacementStrategy
        : ZIO[Any, AwsError, zio.aws.emr.model.PlacementGroupStrategy] =
      AwsError.unwrapOptionField("placementStrategy", placementStrategy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.PlacementGroupConfig
  ) extends zio.aws.emr.model.PlacementGroupConfig.ReadOnly {
    override val instanceRole: zio.aws.emr.model.InstanceRoleType =
      zio.aws.emr.model.InstanceRoleType.wrap(impl.instanceRole())
    override val placementStrategy
        : Option[zio.aws.emr.model.PlacementGroupStrategy] = scala
      .Option(impl.placementStrategy())
      .map(value => zio.aws.emr.model.PlacementGroupStrategy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.PlacementGroupConfig
  ): zio.aws.emr.model.PlacementGroupConfig.ReadOnly = new Wrapper(impl)
}
