package zio.aws.emr.model
import zio.aws.emr.model.primitives.{Date, XmlString, XmlStringMaxLen256}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class NotebookExecution(
    notebookExecutionId: Option[XmlStringMaxLen256] = None,
    editorId: Option[XmlStringMaxLen256] = None,
    executionEngine: Option[zio.aws.emr.model.ExecutionEngineConfig] = None,
    notebookExecutionName: Option[XmlStringMaxLen256] = None,
    notebookParams: Option[XmlString] = None,
    status: Option[zio.aws.emr.model.NotebookExecutionStatus] = None,
    startTime: Option[Date] = None,
    endTime: Option[Date] = None,
    arn: Option[XmlStringMaxLen256] = None,
    outputNotebookURI: Option[XmlString] = None,
    lastStateChangeReason: Option[XmlString] = None,
    notebookInstanceSecurityGroupId: Option[XmlStringMaxLen256] = None,
    tags: Option[Iterable[zio.aws.emr.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.NotebookExecution = {
    import NotebookExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.NotebookExecution
      .builder()
      .optionallyWith(
        notebookExecutionId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.notebookExecutionId)
      .optionallyWith(
        editorId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.editorId)
      .optionallyWith(executionEngine.map(value => value.buildAwsValue()))(
        _.executionEngine
      )
      .optionallyWith(
        notebookExecutionName.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.notebookExecutionName)
      .optionallyWith(
        notebookParams.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.notebookParams)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(startTime.map(value => Date.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Date.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        arn.map(value => XmlStringMaxLen256.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        outputNotebookURI.map(value =>
          XmlString.unwrap(value): java.lang.String
        )
      )(_.outputNotebookURI)
      .optionallyWith(
        lastStateChangeReason.map(value =>
          XmlString.unwrap(value): java.lang.String
        )
      )(_.lastStateChangeReason)
      .optionallyWith(
        notebookInstanceSecurityGroupId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.notebookInstanceSecurityGroupId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.NotebookExecution.ReadOnly =
    zio.aws.emr.model.NotebookExecution.wrap(buildAwsValue())
}
object NotebookExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.NotebookExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.NotebookExecution =
      zio.aws.emr.model.NotebookExecution(
        notebookExecutionId.map(value => value),
        editorId.map(value => value),
        executionEngine.map(value => value.asEditable),
        notebookExecutionName.map(value => value),
        notebookParams.map(value => value),
        status.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        arn.map(value => value),
        outputNotebookURI.map(value => value),
        lastStateChangeReason.map(value => value),
        notebookInstanceSecurityGroupId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def notebookExecutionId: Option[XmlStringMaxLen256]
    def editorId: Option[XmlStringMaxLen256]
    def executionEngine
        : Option[zio.aws.emr.model.ExecutionEngineConfig.ReadOnly]
    def notebookExecutionName: Option[XmlStringMaxLen256]
    def notebookParams: Option[XmlString]
    def status: Option[zio.aws.emr.model.NotebookExecutionStatus]
    def startTime: Option[Date]
    def endTime: Option[Date]
    def arn: Option[XmlStringMaxLen256]
    def outputNotebookURI: Option[XmlString]
    def lastStateChangeReason: Option[XmlString]
    def notebookInstanceSecurityGroupId: Option[XmlStringMaxLen256]
    def tags: Option[List[zio.aws.emr.model.Tag.ReadOnly]]
    def getNotebookExecutionId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("notebookExecutionId", notebookExecutionId)
    def getEditorId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("editorId", editorId)
    def getExecutionEngine
        : ZIO[Any, AwsError, zio.aws.emr.model.ExecutionEngineConfig.ReadOnly] =
      AwsError.unwrapOptionField("executionEngine", executionEngine)
    def getNotebookExecutionName: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("notebookExecutionName", notebookExecutionName)
    def getNotebookParams: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("notebookParams", notebookParams)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.emr.model.NotebookExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStartTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getArn: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("arn", arn)
    def getOutputNotebookURI: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("outputNotebookURI", outputNotebookURI)
    def getLastStateChangeReason: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("lastStateChangeReason", lastStateChangeReason)
    def getNotebookInstanceSecurityGroupId
        : ZIO[Any, AwsError, XmlStringMaxLen256] = AwsError.unwrapOptionField(
      "notebookInstanceSecurityGroupId",
      notebookInstanceSecurityGroupId
    )
    def getTags: ZIO[Any, AwsError, List[zio.aws.emr.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.NotebookExecution
  ) extends zio.aws.emr.model.NotebookExecution.ReadOnly {
    override val notebookExecutionId: Option[XmlStringMaxLen256] = scala
      .Option(impl.notebookExecutionId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val editorId: Option[XmlStringMaxLen256] = scala
      .Option(impl.editorId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val executionEngine
        : Option[zio.aws.emr.model.ExecutionEngineConfig.ReadOnly] = scala
      .Option(impl.executionEngine())
      .map(value => zio.aws.emr.model.ExecutionEngineConfig.wrap(value))
    override val notebookExecutionName: Option[XmlStringMaxLen256] = scala
      .Option(impl.notebookExecutionName())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val notebookParams: Option[XmlString] = scala
      .Option(impl.notebookParams())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val status: Option[zio.aws.emr.model.NotebookExecutionStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.emr.model.NotebookExecutionStatus.wrap(value))
    override val startTime: Option[Date] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
    override val endTime: Option[Date] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
    override val arn: Option[XmlStringMaxLen256] = scala
      .Option(impl.arn())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val outputNotebookURI: Option[XmlString] = scala
      .Option(impl.outputNotebookURI())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val lastStateChangeReason: Option[XmlString] = scala
      .Option(impl.lastStateChangeReason())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val notebookInstanceSecurityGroupId: Option[XmlStringMaxLen256] =
      scala
        .Option(impl.notebookInstanceSecurityGroupId())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val tags: Option[List[zio.aws.emr.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.NotebookExecution
  ): zio.aws.emr.model.NotebookExecution.ReadOnly = new Wrapper(impl)
}
