package zio.aws.emr.model
import zio.aws.emr.model.primitives.Marker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListSecurityConfigurationsRequest(
    marker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsRequest = {
    import ListSecurityConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsRequest
      .builder()
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ListSecurityConfigurationsRequest.ReadOnly =
    zio.aws.emr.model.ListSecurityConfigurationsRequest.wrap(buildAwsValue())
}
object ListSecurityConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListSecurityConfigurationsRequest =
      zio.aws.emr.model
        .ListSecurityConfigurationsRequest(marker.map(value => value))
    def marker: Option[Marker]
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsRequest
  ) extends zio.aws.emr.model.ListSecurityConfigurationsRequest.ReadOnly {
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.emr.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsRequest
  ): zio.aws.emr.model.ListSecurityConfigurationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
