package zio.aws.emr.model
import zio.aws.emr.model.primitives.{Marker, ClusterId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListInstanceGroupsRequest(
    clusterId: ClusterId,
    marker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListInstanceGroupsRequest = {
    import ListInstanceGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListInstanceGroupsRequest
      .builder()
      .clusterId(ClusterId.unwrap(clusterId): java.lang.String)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ListInstanceGroupsRequest.ReadOnly =
    zio.aws.emr.model.ListInstanceGroupsRequest.wrap(buildAwsValue())
}
object ListInstanceGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListInstanceGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListInstanceGroupsRequest =
      zio.aws.emr.model
        .ListInstanceGroupsRequest(clusterId, marker.map(value => value))
    def clusterId: ClusterId
    def marker: Option[Marker]
    def getClusterId: ZIO[Any, Nothing, ClusterId] = ZIO.succeed(clusterId)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListInstanceGroupsRequest
  ) extends zio.aws.emr.model.ListInstanceGroupsRequest.ReadOnly {
    override val clusterId: ClusterId =
      zio.aws.emr.model.primitives.ClusterId(impl.clusterId())
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.emr.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListInstanceGroupsRequest
  ): zio.aws.emr.model.ListInstanceGroupsRequest.ReadOnly = new Wrapper(impl)
}
