package zio.aws.emr.model
import zio.aws.emr.model.primitives.Marker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListBootstrapActionsResponse(
    bootstrapActions: Option[Iterable[zio.aws.emr.model.Command]] = None,
    marker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListBootstrapActionsResponse = {
    import ListBootstrapActionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListBootstrapActionsResponse
      .builder()
      .optionallyWith(
        bootstrapActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bootstrapActions)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ListBootstrapActionsResponse.ReadOnly =
    zio.aws.emr.model.ListBootstrapActionsResponse.wrap(buildAwsValue())
}
object ListBootstrapActionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListBootstrapActionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListBootstrapActionsResponse =
      zio.aws.emr.model.ListBootstrapActionsResponse(
        bootstrapActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def bootstrapActions: Option[List[zio.aws.emr.model.Command.ReadOnly]]
    def marker: Option[Marker]
    def getBootstrapActions
        : ZIO[Any, AwsError, List[zio.aws.emr.model.Command.ReadOnly]] =
      AwsError.unwrapOptionField("bootstrapActions", bootstrapActions)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListBootstrapActionsResponse
  ) extends zio.aws.emr.model.ListBootstrapActionsResponse.ReadOnly {
    override val bootstrapActions
        : Option[List[zio.aws.emr.model.Command.ReadOnly]] = scala
      .Option(impl.bootstrapActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.Command.wrap(item)
        }.toList
      )
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.emr.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListBootstrapActionsResponse
  ): zio.aws.emr.model.ListBootstrapActionsResponse.ReadOnly = new Wrapper(impl)
}
