package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EbsVolume(
    device: Option[String] = None,
    volumeId: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.emr.model.EbsVolume = {
    import EbsVolume.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.EbsVolume
      .builder()
      .optionallyWith(device.map(value => value: java.lang.String))(_.device)
      .optionallyWith(volumeId.map(value => value: java.lang.String))(
        _.volumeId
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.EbsVolume.ReadOnly =
    zio.aws.emr.model.EbsVolume.wrap(buildAwsValue())
}
object EbsVolume {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.EbsVolume] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.EbsVolume = zio.aws.emr.model
      .EbsVolume(device.map(value => value), volumeId.map(value => value))
    def device: Option[String]
    def volumeId: Option[String]
    def getDevice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("device", device)
    def getVolumeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("volumeId", volumeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.EbsVolume
  ) extends zio.aws.emr.model.EbsVolume.ReadOnly {
    override val device: Option[String] =
      scala.Option(impl.device()).map(value => value: String)
    override val volumeId: Option[String] =
      scala.Option(impl.volumeId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.EbsVolume
  ): zio.aws.emr.model.EbsVolume.ReadOnly = new Wrapper(impl)
}
