package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeReleaseLabelResponse(
    releaseLabel: Option[String] = None,
    applications: Option[Iterable[zio.aws.emr.model.SimplifiedApplication]] =
      None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.DescribeReleaseLabelResponse = {
    import DescribeReleaseLabelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.DescribeReleaseLabelResponse
      .builder()
      .optionallyWith(releaseLabel.map(value => value: java.lang.String))(
        _.releaseLabel
      )
      .optionallyWith(
        applications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applications)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.DescribeReleaseLabelResponse.ReadOnly =
    zio.aws.emr.model.DescribeReleaseLabelResponse.wrap(buildAwsValue())
}
object DescribeReleaseLabelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.DescribeReleaseLabelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.DescribeReleaseLabelResponse =
      zio.aws.emr.model.DescribeReleaseLabelResponse(
        releaseLabel.map(value => value),
        applications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def releaseLabel: Option[String]
    def applications
        : Option[List[zio.aws.emr.model.SimplifiedApplication.ReadOnly]]
    def nextToken: Option[String]
    def getReleaseLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("releaseLabel", releaseLabel)
    def getApplications: ZIO[Any, AwsError, List[
      zio.aws.emr.model.SimplifiedApplication.ReadOnly
    ]] = AwsError.unwrapOptionField("applications", applications)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.DescribeReleaseLabelResponse
  ) extends zio.aws.emr.model.DescribeReleaseLabelResponse.ReadOnly {
    override val releaseLabel: Option[String] =
      scala.Option(impl.releaseLabel()).map(value => value: String)
    override val applications
        : Option[List[zio.aws.emr.model.SimplifiedApplication.ReadOnly]] = scala
      .Option(impl.applications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.SimplifiedApplication.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.DescribeReleaseLabelResponse
  ): zio.aws.emr.model.DescribeReleaseLabelResponse.ReadOnly = new Wrapper(impl)
}
