package zio.aws.emr.model
import zio.aws.emr.model.primitives.{
  XmlStringMaxLen256,
  ArnType,
  XmlString,
  Integer,
  OptionalArnType,
  ClusterId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Cluster(
    id: Option[ClusterId] = None,
    name: Option[String] = None,
    status: Option[zio.aws.emr.model.ClusterStatus] = None,
    ec2InstanceAttributes: Option[zio.aws.emr.model.Ec2InstanceAttributes] =
      None,
    instanceCollectionType: Option[zio.aws.emr.model.InstanceCollectionType] =
      None,
    logUri: Option[String] = None,
    logEncryptionKmsKeyId: Option[String] = None,
    requestedAmiVersion: Option[String] = None,
    runningAmiVersion: Option[String] = None,
    releaseLabel: Option[String] = None,
    autoTerminate: Option[Boolean] = None,
    terminationProtected: Option[Boolean] = None,
    visibleToAllUsers: Option[Boolean] = None,
    applications: Option[Iterable[zio.aws.emr.model.Application]] = None,
    tags: Option[Iterable[zio.aws.emr.model.Tag]] = None,
    serviceRole: Option[String] = None,
    normalizedInstanceHours: Option[Integer] = None,
    masterPublicDnsName: Option[String] = None,
    configurations: Option[Iterable[zio.aws.emr.model.Configuration]] = None,
    securityConfiguration: Option[XmlString] = None,
    autoScalingRole: Option[XmlString] = None,
    scaleDownBehavior: Option[zio.aws.emr.model.ScaleDownBehavior] = None,
    customAmiId: Option[XmlStringMaxLen256] = None,
    ebsRootVolumeSize: Option[Integer] = None,
    repoUpgradeOnBoot: Option[zio.aws.emr.model.RepoUpgradeOnBoot] = None,
    kerberosAttributes: Option[zio.aws.emr.model.KerberosAttributes] = None,
    clusterArn: Option[ArnType] = None,
    outpostArn: Option[OptionalArnType] = None,
    stepConcurrencyLevel: Option[Integer] = None,
    placementGroups: Option[Iterable[zio.aws.emr.model.PlacementGroupConfig]] =
      None
) {
  def buildAwsValue(): software.amazon.awssdk.services.emr.model.Cluster = {
    import Cluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.Cluster
      .builder()
      .optionallyWith(
        id.map(value => ClusterId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(
        ec2InstanceAttributes.map(value => value.buildAwsValue())
      )(_.ec2InstanceAttributes)
      .optionallyWith(instanceCollectionType.map(value => value.unwrap))(
        _.instanceCollectionType
      )
      .optionallyWith(logUri.map(value => value: java.lang.String))(_.logUri)
      .optionallyWith(
        logEncryptionKmsKeyId.map(value => value: java.lang.String)
      )(_.logEncryptionKmsKeyId)
      .optionallyWith(
        requestedAmiVersion.map(value => value: java.lang.String)
      )(_.requestedAmiVersion)
      .optionallyWith(runningAmiVersion.map(value => value: java.lang.String))(
        _.runningAmiVersion
      )
      .optionallyWith(releaseLabel.map(value => value: java.lang.String))(
        _.releaseLabel
      )
      .optionallyWith(autoTerminate.map(value => value: java.lang.Boolean))(
        _.autoTerminate
      )
      .optionallyWith(
        terminationProtected.map(value => value: java.lang.Boolean)
      )(_.terminationProtected)
      .optionallyWith(visibleToAllUsers.map(value => value: java.lang.Boolean))(
        _.visibleToAllUsers
      )
      .optionallyWith(
        applications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applications)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(serviceRole.map(value => value: java.lang.String))(
        _.serviceRole
      )
      .optionallyWith(
        normalizedInstanceHours.map(value => value: java.lang.Integer)
      )(_.normalizedInstanceHours)
      .optionallyWith(
        masterPublicDnsName.map(value => value: java.lang.String)
      )(_.masterPublicDnsName)
      .optionallyWith(
        configurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configurations)
      .optionallyWith(
        securityConfiguration.map(value =>
          XmlString.unwrap(value): java.lang.String
        )
      )(_.securityConfiguration)
      .optionallyWith(
        autoScalingRole.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.autoScalingRole)
      .optionallyWith(scaleDownBehavior.map(value => value.unwrap))(
        _.scaleDownBehavior
      )
      .optionallyWith(
        customAmiId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.customAmiId)
      .optionallyWith(ebsRootVolumeSize.map(value => value: java.lang.Integer))(
        _.ebsRootVolumeSize
      )
      .optionallyWith(repoUpgradeOnBoot.map(value => value.unwrap))(
        _.repoUpgradeOnBoot
      )
      .optionallyWith(kerberosAttributes.map(value => value.buildAwsValue()))(
        _.kerberosAttributes
      )
      .optionallyWith(
        clusterArn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.clusterArn)
      .optionallyWith(
        outpostArn.map(value => OptionalArnType.unwrap(value): java.lang.String)
      )(_.outpostArn)
      .optionallyWith(
        stepConcurrencyLevel.map(value => value: java.lang.Integer)
      )(_.stepConcurrencyLevel)
      .optionallyWith(
        placementGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementGroups)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.Cluster.ReadOnly =
    zio.aws.emr.model.Cluster.wrap(buildAwsValue())
}
object Cluster {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.Cluster] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.Cluster = zio.aws.emr.model.Cluster(
      id.map(value => value),
      name.map(value => value),
      status.map(value => value.asEditable),
      ec2InstanceAttributes.map(value => value.asEditable),
      instanceCollectionType.map(value => value),
      logUri.map(value => value),
      logEncryptionKmsKeyId.map(value => value),
      requestedAmiVersion.map(value => value),
      runningAmiVersion.map(value => value),
      releaseLabel.map(value => value),
      autoTerminate.map(value => value),
      terminationProtected.map(value => value),
      visibleToAllUsers.map(value => value),
      applications.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      serviceRole.map(value => value),
      normalizedInstanceHours.map(value => value),
      masterPublicDnsName.map(value => value),
      configurations.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      securityConfiguration.map(value => value),
      autoScalingRole.map(value => value),
      scaleDownBehavior.map(value => value),
      customAmiId.map(value => value),
      ebsRootVolumeSize.map(value => value),
      repoUpgradeOnBoot.map(value => value),
      kerberosAttributes.map(value => value.asEditable),
      clusterArn.map(value => value),
      outpostArn.map(value => value),
      stepConcurrencyLevel.map(value => value),
      placementGroups.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def id: Option[ClusterId]
    def name: Option[String]
    def status: Option[zio.aws.emr.model.ClusterStatus.ReadOnly]
    def ec2InstanceAttributes
        : Option[zio.aws.emr.model.Ec2InstanceAttributes.ReadOnly]
    def instanceCollectionType: Option[zio.aws.emr.model.InstanceCollectionType]
    def logUri: Option[String]
    def logEncryptionKmsKeyId: Option[String]
    def requestedAmiVersion: Option[String]
    def runningAmiVersion: Option[String]
    def releaseLabel: Option[String]
    def autoTerminate: Option[Boolean]
    def terminationProtected: Option[Boolean]
    def visibleToAllUsers: Option[Boolean]
    def applications: Option[List[zio.aws.emr.model.Application.ReadOnly]]
    def tags: Option[List[zio.aws.emr.model.Tag.ReadOnly]]
    def serviceRole: Option[String]
    def normalizedInstanceHours: Option[Integer]
    def masterPublicDnsName: Option[String]
    def configurations: Option[List[zio.aws.emr.model.Configuration.ReadOnly]]
    def securityConfiguration: Option[XmlString]
    def autoScalingRole: Option[XmlString]
    def scaleDownBehavior: Option[zio.aws.emr.model.ScaleDownBehavior]
    def customAmiId: Option[XmlStringMaxLen256]
    def ebsRootVolumeSize: Option[Integer]
    def repoUpgradeOnBoot: Option[zio.aws.emr.model.RepoUpgradeOnBoot]
    def kerberosAttributes
        : Option[zio.aws.emr.model.KerberosAttributes.ReadOnly]
    def clusterArn: Option[ArnType]
    def outpostArn: Option[OptionalArnType]
    def stepConcurrencyLevel: Option[Integer]
    def placementGroups
        : Option[List[zio.aws.emr.model.PlacementGroupConfig.ReadOnly]]
    def getId: ZIO[Any, AwsError, ClusterId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.emr.model.ClusterStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
    def getEc2InstanceAttributes
        : ZIO[Any, AwsError, zio.aws.emr.model.Ec2InstanceAttributes.ReadOnly] =
      AwsError.unwrapOptionField("ec2InstanceAttributes", ec2InstanceAttributes)
    def getInstanceCollectionType
        : ZIO[Any, AwsError, zio.aws.emr.model.InstanceCollectionType] =
      AwsError.unwrapOptionField(
        "instanceCollectionType",
        instanceCollectionType
      )
    def getLogUri: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logUri", logUri)
    def getLogEncryptionKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logEncryptionKmsKeyId", logEncryptionKmsKeyId)
    def getRequestedAmiVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requestedAmiVersion", requestedAmiVersion)
    def getRunningAmiVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("runningAmiVersion", runningAmiVersion)
    def getReleaseLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("releaseLabel", releaseLabel)
    def getAutoTerminate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoTerminate", autoTerminate)
    def getTerminationProtected: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("terminationProtected", terminationProtected)
    def getVisibleToAllUsers: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("visibleToAllUsers", visibleToAllUsers)
    def getApplications
        : ZIO[Any, AwsError, List[zio.aws.emr.model.Application.ReadOnly]] =
      AwsError.unwrapOptionField("applications", applications)
    def getTags: ZIO[Any, AwsError, List[zio.aws.emr.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getServiceRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getNormalizedInstanceHours: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("normalizedInstanceHours", normalizedInstanceHours)
    def getMasterPublicDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterPublicDnsName", masterPublicDnsName)
    def getConfigurations
        : ZIO[Any, AwsError, List[zio.aws.emr.model.Configuration.ReadOnly]] =
      AwsError.unwrapOptionField("configurations", configurations)
    def getSecurityConfiguration: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("securityConfiguration", securityConfiguration)
    def getAutoScalingRole: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("autoScalingRole", autoScalingRole)
    def getScaleDownBehavior
        : ZIO[Any, AwsError, zio.aws.emr.model.ScaleDownBehavior] =
      AwsError.unwrapOptionField("scaleDownBehavior", scaleDownBehavior)
    def getCustomAmiId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("customAmiId", customAmiId)
    def getEbsRootVolumeSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ebsRootVolumeSize", ebsRootVolumeSize)
    def getRepoUpgradeOnBoot
        : ZIO[Any, AwsError, zio.aws.emr.model.RepoUpgradeOnBoot] =
      AwsError.unwrapOptionField("repoUpgradeOnBoot", repoUpgradeOnBoot)
    def getKerberosAttributes
        : ZIO[Any, AwsError, zio.aws.emr.model.KerberosAttributes.ReadOnly] =
      AwsError.unwrapOptionField("kerberosAttributes", kerberosAttributes)
    def getClusterArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getOutpostArn: ZIO[Any, AwsError, OptionalArnType] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getStepConcurrencyLevel: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("stepConcurrencyLevel", stepConcurrencyLevel)
    def getPlacementGroups: ZIO[Any, AwsError, List[
      zio.aws.emr.model.PlacementGroupConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("placementGroups", placementGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.Cluster
  ) extends zio.aws.emr.model.Cluster.ReadOnly {
    override val id: Option[ClusterId] = scala
      .Option(impl.id())
      .map(value => zio.aws.emr.model.primitives.ClusterId(value))
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val status: Option[zio.aws.emr.model.ClusterStatus.ReadOnly] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.emr.model.ClusterStatus.wrap(value))
    override val ec2InstanceAttributes
        : Option[zio.aws.emr.model.Ec2InstanceAttributes.ReadOnly] = scala
      .Option(impl.ec2InstanceAttributes())
      .map(value => zio.aws.emr.model.Ec2InstanceAttributes.wrap(value))
    override val instanceCollectionType
        : Option[zio.aws.emr.model.InstanceCollectionType] = scala
      .Option(impl.instanceCollectionType())
      .map(value => zio.aws.emr.model.InstanceCollectionType.wrap(value))
    override val logUri: Option[String] =
      scala.Option(impl.logUri()).map(value => value: String)
    override val logEncryptionKmsKeyId: Option[String] =
      scala.Option(impl.logEncryptionKmsKeyId()).map(value => value: String)
    override val requestedAmiVersion: Option[String] =
      scala.Option(impl.requestedAmiVersion()).map(value => value: String)
    override val runningAmiVersion: Option[String] =
      scala.Option(impl.runningAmiVersion()).map(value => value: String)
    override val releaseLabel: Option[String] =
      scala.Option(impl.releaseLabel()).map(value => value: String)
    override val autoTerminate: Option[Boolean] =
      scala.Option(impl.autoTerminate()).map(value => value: Boolean)
    override val terminationProtected: Option[Boolean] =
      scala.Option(impl.terminationProtected()).map(value => value: Boolean)
    override val visibleToAllUsers: Option[Boolean] =
      scala.Option(impl.visibleToAllUsers()).map(value => value: Boolean)
    override val applications
        : Option[List[zio.aws.emr.model.Application.ReadOnly]] = scala
      .Option(impl.applications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.Application.wrap(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.emr.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.Tag.wrap(item)
        }.toList
      )
    override val serviceRole: Option[String] =
      scala.Option(impl.serviceRole()).map(value => value: String)
    override val normalizedInstanceHours: Option[Integer] =
      scala.Option(impl.normalizedInstanceHours()).map(value => value: Integer)
    override val masterPublicDnsName: Option[String] =
      scala.Option(impl.masterPublicDnsName()).map(value => value: String)
    override val configurations
        : Option[List[zio.aws.emr.model.Configuration.ReadOnly]] = scala
      .Option(impl.configurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.Configuration.wrap(item)
        }.toList
      )
    override val securityConfiguration: Option[XmlString] = scala
      .Option(impl.securityConfiguration())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val autoScalingRole: Option[XmlString] = scala
      .Option(impl.autoScalingRole())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val scaleDownBehavior
        : Option[zio.aws.emr.model.ScaleDownBehavior] = scala
      .Option(impl.scaleDownBehavior())
      .map(value => zio.aws.emr.model.ScaleDownBehavior.wrap(value))
    override val customAmiId: Option[XmlStringMaxLen256] = scala
      .Option(impl.customAmiId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val ebsRootVolumeSize: Option[Integer] =
      scala.Option(impl.ebsRootVolumeSize()).map(value => value: Integer)
    override val repoUpgradeOnBoot
        : Option[zio.aws.emr.model.RepoUpgradeOnBoot] = scala
      .Option(impl.repoUpgradeOnBoot())
      .map(value => zio.aws.emr.model.RepoUpgradeOnBoot.wrap(value))
    override val kerberosAttributes
        : Option[zio.aws.emr.model.KerberosAttributes.ReadOnly] = scala
      .Option(impl.kerberosAttributes())
      .map(value => zio.aws.emr.model.KerberosAttributes.wrap(value))
    override val clusterArn: Option[ArnType] = scala
      .Option(impl.clusterArn())
      .map(value => zio.aws.emr.model.primitives.ArnType(value))
    override val outpostArn: Option[OptionalArnType] = scala
      .Option(impl.outpostArn())
      .map(value => zio.aws.emr.model.primitives.OptionalArnType(value))
    override val stepConcurrencyLevel: Option[Integer] =
      scala.Option(impl.stepConcurrencyLevel()).map(value => value: Integer)
    override val placementGroups
        : Option[List[zio.aws.emr.model.PlacementGroupConfig.ReadOnly]] = scala
      .Option(impl.placementGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.PlacementGroupConfig.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.Cluster
  ): zio.aws.emr.model.Cluster.ReadOnly = new Wrapper(impl)
}
