package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait AutoScalingPolicyState {
  def unwrap: software.amazon.awssdk.services.emr.model.AutoScalingPolicyState
}
object AutoScalingPolicyState {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.AutoScalingPolicyState
  ): zio.aws.emr.model.AutoScalingPolicyState = value match {
    case software.amazon.awssdk.services.emr.model.AutoScalingPolicyState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.AutoScalingPolicyState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.emr.model.AutoScalingPolicyState.ATTACHING =>
      val r = ATTACHING
      r
    case software.amazon.awssdk.services.emr.model.AutoScalingPolicyState.ATTACHED =>
      val r = ATTACHED
      r
    case software.amazon.awssdk.services.emr.model.AutoScalingPolicyState.DETACHING =>
      val r = DETACHING
      r
    case software.amazon.awssdk.services.emr.model.AutoScalingPolicyState.DETACHED =>
      val r = DETACHED
      r
    case software.amazon.awssdk.services.emr.model.AutoScalingPolicyState.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.emr.model.AutoScalingPolicyState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.AutoScalingPolicyState =
      software.amazon.awssdk.services.emr.model.AutoScalingPolicyState.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.emr.model.AutoScalingPolicyState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.AutoScalingPolicyState =
      software.amazon.awssdk.services.emr.model.AutoScalingPolicyState.PENDING
  }
  case object ATTACHING extends zio.aws.emr.model.AutoScalingPolicyState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.AutoScalingPolicyState =
      software.amazon.awssdk.services.emr.model.AutoScalingPolicyState.ATTACHING
  }
  case object ATTACHED extends zio.aws.emr.model.AutoScalingPolicyState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.AutoScalingPolicyState =
      software.amazon.awssdk.services.emr.model.AutoScalingPolicyState.ATTACHED
  }
  case object DETACHING extends zio.aws.emr.model.AutoScalingPolicyState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.AutoScalingPolicyState =
      software.amazon.awssdk.services.emr.model.AutoScalingPolicyState.DETACHING
  }
  case object DETACHED extends zio.aws.emr.model.AutoScalingPolicyState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.AutoScalingPolicyState =
      software.amazon.awssdk.services.emr.model.AutoScalingPolicyState.DETACHED
  }
  case object FAILED extends zio.aws.emr.model.AutoScalingPolicyState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.AutoScalingPolicyState =
      software.amazon.awssdk.services.emr.model.AutoScalingPolicyState.FAILED
  }
}
