package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StepStatus(
    state: Option[zio.aws.emr.model.StepState] = None,
    stateChangeReason: Option[zio.aws.emr.model.StepStateChangeReason] = None,
    failureDetails: Option[zio.aws.emr.model.FailureDetails] = None,
    timeline: Option[zio.aws.emr.model.StepTimeline] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.emr.model.StepStatus = {
    import StepStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.StepStatus
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateChangeReason.map(value => value.buildAwsValue()))(
        _.stateChangeReason
      )
      .optionallyWith(failureDetails.map(value => value.buildAwsValue()))(
        _.failureDetails
      )
      .optionallyWith(timeline.map(value => value.buildAwsValue()))(_.timeline)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.StepStatus.ReadOnly =
    zio.aws.emr.model.StepStatus.wrap(buildAwsValue())
}
object StepStatus {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.StepStatus] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.StepStatus = zio.aws.emr.model.StepStatus(
      state.map(value => value),
      stateChangeReason.map(value => value.asEditable),
      failureDetails.map(value => value.asEditable),
      timeline.map(value => value.asEditable)
    )
    def state: Option[zio.aws.emr.model.StepState]
    def stateChangeReason
        : Option[zio.aws.emr.model.StepStateChangeReason.ReadOnly]
    def failureDetails: Option[zio.aws.emr.model.FailureDetails.ReadOnly]
    def timeline: Option[zio.aws.emr.model.StepTimeline.ReadOnly]
    def getState: ZIO[Any, AwsError, zio.aws.emr.model.StepState] =
      AwsError.unwrapOptionField("state", state)
    def getStateChangeReason
        : ZIO[Any, AwsError, zio.aws.emr.model.StepStateChangeReason.ReadOnly] =
      AwsError.unwrapOptionField("stateChangeReason", stateChangeReason)
    def getFailureDetails
        : ZIO[Any, AwsError, zio.aws.emr.model.FailureDetails.ReadOnly] =
      AwsError.unwrapOptionField("failureDetails", failureDetails)
    def getTimeline
        : ZIO[Any, AwsError, zio.aws.emr.model.StepTimeline.ReadOnly] =
      AwsError.unwrapOptionField("timeline", timeline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.StepStatus
  ) extends zio.aws.emr.model.StepStatus.ReadOnly {
    override val state: Option[zio.aws.emr.model.StepState] = scala
      .Option(impl.state())
      .map(value => zio.aws.emr.model.StepState.wrap(value))
    override val stateChangeReason
        : Option[zio.aws.emr.model.StepStateChangeReason.ReadOnly] = scala
      .Option(impl.stateChangeReason())
      .map(value => zio.aws.emr.model.StepStateChangeReason.wrap(value))
    override val failureDetails
        : Option[zio.aws.emr.model.FailureDetails.ReadOnly] = scala
      .Option(impl.failureDetails())
      .map(value => zio.aws.emr.model.FailureDetails.wrap(value))
    override val timeline: Option[zio.aws.emr.model.StepTimeline.ReadOnly] =
      scala
        .Option(impl.timeline())
        .map(value => zio.aws.emr.model.StepTimeline.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.StepStatus
  ): zio.aws.emr.model.StepStatus.ReadOnly = new Wrapper(impl)
}
