package zio.aws.emr.model
import zio.aws.emr.model.primitives.{XmlString, XmlStringMaxLen256}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartNotebookExecutionRequest(
    editorId: XmlStringMaxLen256,
    relativePath: XmlString,
    notebookExecutionName: Option[XmlStringMaxLen256] = None,
    notebookParams: Option[XmlString] = None,
    executionEngine: zio.aws.emr.model.ExecutionEngineConfig,
    serviceRole: XmlString,
    notebookInstanceSecurityGroupId: Option[XmlStringMaxLen256] = None,
    tags: Option[Iterable[zio.aws.emr.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.StartNotebookExecutionRequest = {
    import StartNotebookExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.StartNotebookExecutionRequest
      .builder()
      .editorId(XmlStringMaxLen256.unwrap(editorId): java.lang.String)
      .relativePath(XmlString.unwrap(relativePath): java.lang.String)
      .optionallyWith(
        notebookExecutionName.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.notebookExecutionName)
      .optionallyWith(
        notebookParams.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.notebookParams)
      .executionEngine(executionEngine.buildAwsValue())
      .serviceRole(XmlString.unwrap(serviceRole): java.lang.String)
      .optionallyWith(
        notebookInstanceSecurityGroupId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.notebookInstanceSecurityGroupId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.StartNotebookExecutionRequest.ReadOnly =
    zio.aws.emr.model.StartNotebookExecutionRequest.wrap(buildAwsValue())
}
object StartNotebookExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.StartNotebookExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.StartNotebookExecutionRequest =
      zio.aws.emr.model.StartNotebookExecutionRequest(
        editorId,
        relativePath,
        notebookExecutionName.map(value => value),
        notebookParams.map(value => value),
        executionEngine.asEditable,
        serviceRole,
        notebookInstanceSecurityGroupId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def editorId: XmlStringMaxLen256
    def relativePath: XmlString
    def notebookExecutionName: Option[XmlStringMaxLen256]
    def notebookParams: Option[XmlString]
    def executionEngine: zio.aws.emr.model.ExecutionEngineConfig.ReadOnly
    def serviceRole: XmlString
    def notebookInstanceSecurityGroupId: Option[XmlStringMaxLen256]
    def tags: Option[List[zio.aws.emr.model.Tag.ReadOnly]]
    def getEditorId: ZIO[Any, Nothing, XmlStringMaxLen256] =
      ZIO.succeed(editorId)
    def getRelativePath: ZIO[Any, Nothing, XmlString] =
      ZIO.succeed(relativePath)
    def getNotebookExecutionName: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("notebookExecutionName", notebookExecutionName)
    def getNotebookParams: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("notebookParams", notebookParams)
    def getExecutionEngine
        : ZIO[Any, Nothing, zio.aws.emr.model.ExecutionEngineConfig.ReadOnly] =
      ZIO.succeed(executionEngine)
    def getServiceRole: ZIO[Any, Nothing, XmlString] = ZIO.succeed(serviceRole)
    def getNotebookInstanceSecurityGroupId
        : ZIO[Any, AwsError, XmlStringMaxLen256] = AwsError.unwrapOptionField(
      "notebookInstanceSecurityGroupId",
      notebookInstanceSecurityGroupId
    )
    def getTags: ZIO[Any, AwsError, List[zio.aws.emr.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.StartNotebookExecutionRequest
  ) extends zio.aws.emr.model.StartNotebookExecutionRequest.ReadOnly {
    override val editorId: XmlStringMaxLen256 =
      zio.aws.emr.model.primitives.XmlStringMaxLen256(impl.editorId())
    override val relativePath: XmlString =
      zio.aws.emr.model.primitives.XmlString(impl.relativePath())
    override val notebookExecutionName: Option[XmlStringMaxLen256] = scala
      .Option(impl.notebookExecutionName())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val notebookParams: Option[XmlString] = scala
      .Option(impl.notebookParams())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val executionEngine
        : zio.aws.emr.model.ExecutionEngineConfig.ReadOnly =
      zio.aws.emr.model.ExecutionEngineConfig.wrap(impl.executionEngine())
    override val serviceRole: XmlString =
      zio.aws.emr.model.primitives.XmlString(impl.serviceRole())
    override val notebookInstanceSecurityGroupId: Option[XmlStringMaxLen256] =
      scala
        .Option(impl.notebookInstanceSecurityGroupId())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val tags: Option[List[zio.aws.emr.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.StartNotebookExecutionRequest
  ): zio.aws.emr.model.StartNotebookExecutionRequest.ReadOnly = new Wrapper(
    impl
  )
}
